/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.spring;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ioc.spring.SeamLifecycleUtils;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.springframework.util.ClassUtils;

public class SeamManagedEntityManagerFactory
implements EntityManagerFactory,
Serializable {
    private static final LogProvider log = Logging.getLogProvider(SeamManagedEntityManagerFactory.class);
    private String persistenceContextName;
    private boolean closed = false;

    public SeamManagedEntityManagerFactory(String seamPersistenceContextName) {
        if (seamPersistenceContextName == null || "".equals(seamPersistenceContextName)) {
            throw new IllegalArgumentException("persistenceContextName cannot be null");
        }
        this.persistenceContextName = seamPersistenceContextName;
    }

    public void close() {
        this.closed = true;
    }

    public EntityManager createEntityManager() {
        if (this.closed) {
            throw new IllegalStateException("EntityManagerFactory is closed");
        }
        log.debug((Object)"Returning a Seam Managed PC from createEntityManager()");
        SeamLifecycleUtils.beginTransactionalSeamCall();
        EntityManager em = (EntityManager)Component.getInstance((String)this.persistenceContextName);
        return (EntityManager)Proxy.newProxyInstance(this.getClass().getClassLoader(), ClassUtils.getAllInterfaces((Object)em), (InvocationHandler)new SeamManagedPersistenceContextHandler(em));
    }

    public EntityManager createEntityManager(Map properties) {
        throw new UnsupportedOperationException("Cannot change properties of a Seam ManagedPersistenceContext this way.  This must be done on the ManagedPersistenceContext seam component.");
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public static class SeamManagedPersistenceContextHandler
    implements InvocationHandler,
    Serializable {
        private static final LogProvider log = Logging.getLogProvider(SeamManagedPersistenceContextHandler.class);
        private EntityManager delegate;
        private boolean closed = false;

        public SeamManagedPersistenceContextHandler(EntityManager delegate) {
            this.delegate = delegate;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(this.hashCode());
            }
            if (method.getName().equals("isOpen")) {
                return this.delegate.isOpen() && !this.closed;
            }
            if (!this.delegate.isOpen()) {
                try {
                    return method.invoke((Object)this.delegate, args);
                }
                catch (InvocationTargetException ex) {
                    throw ex.getTargetException();
                }
            }
            if (this.closed) {
                throw new IllegalStateException("This PersistenceContext is closed.");
            }
            if (method.getName().equals("close")) {
                log.debug((Object)"Closing PersistenceContext Proxy.");
                this.closed = true;
                return null;
            }
            try {
                return method.invoke((Object)this.delegate, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

