/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.spring;

import org.jboss.seam.ScopeType;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SeamLifecycleUtils {
    private static final LogProvider log = Logging.getLogProvider(SeamLifecycleUtils.class);
    public static final int SEAM_LIFECYCLE_SYNCHRONIZATION_ORDER = Integer.MAX_VALUE;

    public static void beginTransactionalSeamCall() {
        if (ScopeType.APPLICATION.isContextActive()) {
            log.debug((Object)"Application available.  Won't start a new call");
            return;
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SeamLifecycleSynchronization());
            log.debug((Object)"Beginning Transactional Seam Call");
            Lifecycle.beginCall();
            return;
        }
        throw new IllegalStateException("Seam application context not available and cannot be started.  Seam Managed Persistence Context not available.  Try placing the spring bean call inside of a spring transaction or try making the spring bean a Seam Component using <seam:component/>.");
    }

    private static class SeamLifecycleSynchronization
    extends TransactionSynchronizationAdapter {
        private SeamLifecycleSynchronization() {
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        public void afterCompletion(int status) {
            if (ScopeType.APPLICATION.isContextActive()) {
                log.debug((Object)"Ending Transactional Seam Call");
                Lifecycle.endCall();
            } else {
                log.warn((Object)"Spring started a transactional Seam call but somebody else closed before it before the transaction committed.");
            }
        }
    }
}

