/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.spring;

import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.ioc.spring.SpringComponent;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public class SeamComponentPostProcessor
implements BeanPostProcessor,
Ordered {
    private int order = Integer.MAX_VALUE;

    public Object postProcessAfterInitialization(final Object bean, String beanName) throws BeansException {
        SpringComponent component = SpringComponent.forSpringBeanName(beanName);
        if (component == null) {
            return bean;
        }
        if (bean instanceof FactoryBean && !FactoryBean.class.isAssignableFrom(component.getBeanClass())) {
            return bean;
        }
        SpringComponent.setObjectFactory(new ObjectFactory(){

            public Object getObject() throws BeansException {
                return bean;
            }
        });
        return Component.getInstance((String)beanName, (ScopeType)component.getScope());
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

