/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc.guice;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.ioc.guice.Guice;
import org.jboss.seam.ioc.guice.GuiceInit;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Interceptor
public class GuiceInterceptor
extends AbstractInterceptor {
    private static final Log log = Logging.getLog(GuiceInterceptor.class);
    private static final long serialVersionUID = -6716553117162905303L;
    private static final String GUICE_COMPONENT_FIELDS_MAP = "org.jboss.seam.GuiceComponentFieldsMap";
    private transient Injector defaultInjector = null;

    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocationContext) throws Exception {
        this.inject(invocationContext.getTarget());
        Object result = invocationContext.proceed();
        this.disinject(invocationContext.getTarget());
        return result;
    }

    private void inject(Object target) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Injecting members of component '#0'", new Object[]{this.getComponent().getName()});
        }
        this.getGuiceInjector().injectMembers(target);
    }

    private void disinject(Object target) throws Exception {
        for (Field guiceField : this.getGuiceAnnotatedFields()) {
            if (!guiceField.isAccessible()) {
                guiceField.setAccessible(true);
            }
            Reflections.set((Field)guiceField, (Object)target, null);
        }
    }

    private Injector getGuiceInjector() {
        Guice guice = this.getComponent().getBeanClass().getAnnotation(Guice.class);
        String expr = guice != null ? guice.value() : null;
        return Strings.isEmpty((String)expr) ? this.getCachedDefaultInjector() : GuiceInterceptor.getInjectorByName(expr);
    }

    private Injector getCachedDefaultInjector() {
        if (this.defaultInjector == null) {
            GuiceInit init = (GuiceInit)Component.getInstance(GuiceInit.class);
            if (init != null) {
                this.defaultInjector = init.getInjector();
            }
            if (this.defaultInjector == null) {
                throw new IllegalStateException("Default Guice injector not specified.");
            }
        }
        return this.defaultInjector;
    }

    private static Injector getInjectorByName(String expr) {
        Object result = expr.startsWith("#") ? Expressions.instance().createValueExpression(expr).getValue() : Component.getInstance((String)expr);
        if (!(result instanceof Injector)) {
            throw new IllegalArgumentException("Expression '" + expr + "' does not evaluate to a Guice injector.");
        }
        return (Injector)result;
    }

    private Collection<Field> getGuiceAnnotatedFields() {
        Map<Class, Collection<Field>> fieldsMap = this.getGuiceComponentFieldsMap();
        List annotatedFields = fieldsMap.get(this.getComponent().getBeanClass());
        if (annotatedFields == null) {
            annotatedFields = Reflections.getFields((Class)this.getComponent().getBeanClass(), Inject.class);
            fieldsMap.put(this.getComponent().getBeanClass(), annotatedFields);
        }
        return annotatedFields;
    }

    private Map<Class, Collection<Field>> getGuiceComponentFieldsMap() {
        if (Contexts.getApplicationContext().get(GUICE_COMPONENT_FIELDS_MAP) == null) {
            Contexts.getApplicationContext().set(GUICE_COMPONENT_FIELDS_MAP, new HashMap());
        }
        return (Map)Contexts.getApplicationContext().get(GUICE_COMPONENT_FIELDS_MAP);
    }

    public boolean isInterceptorEnabled() {
        return true;
    }
}

