/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.utils;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.utils.Process;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Utility {
    private static final byte[] HEX_DIGITS = new byte[16];
    private static volatile long[] myAddr;
    private static Uid processUid;
    private static volatile Process processHandle;
    private static final String hexStart = "0x";
    private static volatile String defaultProcessId;
    private static boolean _isAndroid;
    public static final int BACKLOG = 50;
    public static final int MAX_PORT = 65535;

    public static String intToHexString(int number) throws NumberFormatException {
        return Integer.toString(number, 16);
    }

    public static int hexStringToInt(String s) throws NumberFormatException {
        boolean isNeg;
        Object toUse = s;
        if (s.startsWith(hexStart)) {
            toUse = s.substring(hexStart.length());
        }
        String lastString = ((String)toUse).substring(((String)toUse).length() - 1);
        if (((String)toUse).substring(0, 1).equals("-")) {
            toUse = "-0" + ((String)toUse).substring(1, ((String)toUse).length() - 1);
            isNeg = true;
        } else {
            toUse = "0" + ((String)toUse).substring(0, ((String)toUse).length() - 1);
            isNeg = false;
        }
        Integer i = Integer.valueOf((String)toUse, 16);
        int val = i;
        val <<= 4;
        val = isNeg ? (val -= Integer.valueOf(lastString, 16).intValue()) : (val += Integer.valueOf(lastString, 16).intValue());
        return val;
    }

    public static String longToHexString(long number) throws NumberFormatException {
        return Long.toString(number, 16);
    }

    public static int hexCharsOf(int value) {
        int signLen = 0;
        if (value < 0) {
            value = -value;
            signLen = 1;
        }
        int nonZeroBits = 32 - Integer.numberOfLeadingZeros(value);
        return signLen + Math.max(nonZeroBits + 3 >> 2, 1);
    }

    public static void toHexChars(int value, byte[] ascii, int offset, int expectedHexChars) {
        int numHexChars = expectedHexChars;
        if (value < 0) {
            value = -value;
            ascii[offset++] = 45;
            --numHexChars;
        }
        for (int i = numHexChars - 1; i >= 0; --i) {
            int digit = value & 0xF;
            ascii[offset + i] = HEX_DIGITS[digit];
            value >>>= 4;
        }
    }

    public static int hexCharsOf(long value) {
        int signLen = 0;
        if (value < 0L) {
            value = -value;
            signLen = 1;
        }
        int nonZeroBits = 64 - Long.numberOfLeadingZeros(value);
        return signLen + Math.max(nonZeroBits + 3 >> 2, 1);
    }

    public static void toHexChars(long value, byte[] ascii, int offset, int expectedHexChars) {
        int numHexChars = expectedHexChars;
        if (value < 0L) {
            value = -value;
            ascii[offset++] = 45;
            --numHexChars;
        }
        for (int i = numHexChars - 1; i >= 0; --i) {
            int digit = (int)(value & 0xFL);
            ascii[offset + i] = HEX_DIGITS[digit];
            value >>>= 4;
        }
    }

    public static long hexStringToLong(String s) throws NumberFormatException {
        boolean isNeg;
        Object toUse = s;
        if (s.startsWith(hexStart)) {
            toUse = s.substring(hexStart.length());
        }
        String lastString = ((String)toUse).substring(((String)toUse).length() - 1);
        if (((String)toUse).substring(0, 1).equals("-")) {
            toUse = "-0" + ((String)toUse).substring(1, ((String)toUse).length() - 1);
            isNeg = true;
        } else {
            toUse = "0" + ((String)toUse).substring(0, ((String)toUse).length() - 1);
            isNeg = false;
        }
        Long i = Long.valueOf((String)toUse, 16);
        long val = i;
        val <<= 4;
        val = isNeg ? (val -= Long.valueOf(lastString, 16).longValue()) : (val += Long.valueOf(lastString, 16).longValue());
        return val;
    }

    public static long[] hostInetAddr() throws UnknownHostException {
        if (myAddr == null) {
            Utility.calculateHostInetAddr();
        }
        return myAddr;
    }

    private static synchronized void calculateHostInetAddr() throws UnknownHostException {
        if (myAddr == null) {
            int l;
            int i;
            InetAddress addr;
            myAddr = new long[2];
            Utility.myAddr[0] = 0L;
            Utility.myAddr[1] = 0L;
            byte[] b = null;
            try {
                addr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                tsLogger.i18NLogger.warn_utils_Utility_2();
                addr = InetAddress.getByName(null);
            }
            if (addr instanceof Inet6Address) {
                b = addr.getAddress();
            } else {
                byte[] v4Address = addr.getAddress();
                if (v4Address.length > 4) {
                    throw new UnknownHostException();
                }
                b = new byte[16];
                for (int i2 = 0; i2 < 10; ++i2) {
                    b[i2] = 0;
                }
                b[11] = -1;
                b[10] = -1;
                System.arraycopy(v4Address, 0, b, 12, v4Address.length);
            }
            for (i = 0; i < 8; ++i) {
                l = 0x7F & b[i];
                Utility.myAddr[0] = myAddr[0] << 8 | (long)(l += 0x80 & b[i]);
            }
            for (i = 8; i < 16; ++i) {
                l = 0x7F & b[i];
                Utility.myAddr[1] = myAddr[1] << 8 | (long)(l += 0x80 & b[i]);
            }
        }
    }

    public static InetAddress hostNameToInetAddress(String host) throws UnknownHostException {
        return InetAddress.getByName(host);
    }

    public static final int getpid() {
        Process handle = Utility.getProcess();
        return handle == null ? -1 : handle.getpid();
    }

    public static Uid getProcessUid() {
        if (processUid == null) {
            Utility.initProcessUid();
        }
        return processUid;
    }

    private static synchronized void initProcessUid() {
        if (processUid == null) {
            processUid = new Uid();
        }
    }

    public static final boolean isWindows() {
        String os = System.getProperty("os.name");
        return "WIN32".equals(os) || os.indexOf("Windows") != -1;
    }

    public static final void setProcess(Process p) {
        processHandle = p;
    }

    private static synchronized void initDefaultProcess() {
        if (processHandle == null && (processHandle = arjPropertyManager.getCoreEnvironmentBean().getProcessImplementation()) == null) {
            tsLogger.i18NLogger.warn_utils_Utility_1();
        }
    }

    private static final Process getProcess() {
        if (processHandle == null) {
            Utility.initDefaultProcess();
        }
        return processHandle;
    }

    public static void validatePortRange(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port value out of range " + port);
        }
    }

    public static synchronized String getDefaultProcessId() {
        Utility.initialise();
        return defaultProcessId;
    }

    public static synchronized boolean isAndroid() {
        Utility.initialise();
        return _isAndroid;
    }

    private static void initialise() {
        if (defaultProcessId == null) {
            String t = System.getProperty("java.vm.vendor");
            if (t.toLowerCase().indexOf("android") != -1) {
                defaultProcessId = "com.arjuna.ats.internal.arjuna.utils.AndroidProcessId";
                _isAndroid = true;
            } else {
                defaultProcessId = "com.arjuna.ats.internal.arjuna.utils.SocketProcessId";
            }
        }
    }

    static {
        Utility.HEX_DIGITS[0] = 48;
        Utility.HEX_DIGITS[1] = 49;
        Utility.HEX_DIGITS[2] = 50;
        Utility.HEX_DIGITS[3] = 51;
        Utility.HEX_DIGITS[4] = 52;
        Utility.HEX_DIGITS[5] = 53;
        Utility.HEX_DIGITS[6] = 54;
        Utility.HEX_DIGITS[7] = 55;
        Utility.HEX_DIGITS[8] = 56;
        Utility.HEX_DIGITS[9] = 57;
        Utility.HEX_DIGITS[10] = 97;
        Utility.HEX_DIGITS[11] = 98;
        Utility.HEX_DIGITS[12] = 99;
        Utility.HEX_DIGITS[13] = 100;
        Utility.HEX_DIGITS[14] = 101;
        Utility.HEX_DIGITS[15] = 102;
        myAddr = null;
        processUid = null;
        processHandle = null;
        defaultProcessId = null;
        _isAndroid = false;
    }
}

