/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.plugins.thirdparty;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jboss.maven.plugins.thirdparty.ComponentInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ComponentInfoReader {
    public static ComponentInfo parseComponentInfo(File compInfoFile) throws IOException, ParserConfigurationException, SAXException {
        if (!compInfoFile.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(compInfoFile);
        ComponentInfo compInfo = ComponentInfoReader.parseComponentInfo(fis);
        fis.close();
        return compInfo;
    }

    public static ComponentInfo parseComponentInfo(InputStream compInfoIS) throws IOException, ParserConfigurationException, SAXException {
        ComponentInfo compInfo = new ComponentInfo();
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(compInfoIS);
        doc.getDocumentElement().normalize();
        Element projectElement = doc.getDocumentElement();
        NodeList componentNodes = projectElement.getElementsByTagName("component");
        Node componentNode = componentNodes.item(0);
        NamedNodeMap componentAttributes = componentNode.getAttributes();
        for (int i = 0; i < componentAttributes.getLength(); ++i) {
            Node attribute = componentAttributes.item(i);
            if (attribute.getNodeName().equals("id")) {
                compInfo.setComponentId(attribute.getNodeValue());
            }
            if (attribute.getNodeName().equals("licenseType")) {
                compInfo.setLicense(attribute.getNodeValue());
            }
            if (attribute.getNodeName().equals("version")) {
                compInfo.setVersion(attribute.getNodeValue());
            }
            if (attribute.getNodeName().equals("description")) {
                compInfo.setDescription(attribute.getNodeValue());
            }
            if (!attribute.getNodeName().equals("scm")) continue;
            compInfo.setScm(attribute.getNodeValue());
        }
        NodeList artifactNodes = projectElement.getElementsByTagName("artifact");
        for (int i = 0; i < artifactNodes.getLength(); ++i) {
            NamedNodeMap artifactAttr = artifactNodes.item(i).getAttributes();
            Node artifactIdNode = artifactAttr.item(0);
            compInfo.addArtifactId(artifactIdNode.getNodeValue());
        }
        NodeList exportNodes = projectElement.getElementsByTagName("include");
        for (int i = 0; i < exportNodes.getLength(); ++i) {
            NamedNodeMap exportAttr = exportNodes.item(i).getAttributes();
            Node exportNode = exportAttr.item(0);
            compInfo.addExport(exportNode.getNodeValue());
        }
        NodeList importNodes = projectElement.getElementsByTagName("import");
        for (int i = 0; i < importNodes.getLength(); ++i) {
            NamedNodeMap importAttr = importNodes.item(i).getAttributes();
            Node componentRefNode = importAttr.item(0);
            NodeList componentRefChildren = importNodes.item(i).getChildNodes();
            String compatVersions = "";
            for (int j = 0; j < componentRefChildren.getLength(); ++j) {
                Node child = componentRefChildren.item(j);
                if (!child.getNodeName().equals("compatible")) continue;
                NamedNodeMap compatibleAttr = child.getAttributes();
                Node compatVersionsNode = compatibleAttr.item(0);
                compatVersions = compatVersionsNode.getNodeValue();
            }
            compInfo.addImport(componentRefNode.getNodeValue(), compatVersions);
        }
        return compInfo;
    }

    public static void verifyCompInfo(String compInfoFilePath) throws SAXException, FileNotFoundException {
        ComponentInfoReader.verifyCompInfo(new FileInputStream(compInfoFilePath));
    }

    public static void verifyCompInfo(InputStream compInfo) throws SAXException {
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = parser.parse(compInfo);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource schemaFile = new StreamSource(ComponentInfoReader.class.getResourceAsStream("/org/jboss/maven/plugins/thirdparty/component-info.xsd"));
            Schema schema = factory.newSchema(schemaFile);
            Validator validator = schema.newValidator();
            validator.validate(new DOMSource(document));
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

