/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import javax.ejb.EJBException;
import javax.sql.DataSource;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.RelationData;
import org.jboss.ejb.plugins.cmp.jdbc.RelationPair;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.logging.Logger;

public final class JDBCInsertRelationsCommand {
    private final Logger log;

    public JDBCInsertRelationsCommand(JDBCStoreManager manager) {
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + manager.getMetaData().getName()));
    }

    public void execute(RelationData relationData) {
        if (relationData.addedRelations.size() == 0) {
            return;
        }
        Connection con = null;
        PreparedStatement ps = null;
        JDBCCMRFieldBridge cmrField = relationData.getLeftCMRField();
        try {
            try {
                String sql = JDBCInsertRelationsCommand.getSQL(relationData);
                boolean debug = this.log.isDebugEnabled();
                if (debug) {
                    this.log.debug((Object)("Executing SQL: " + sql));
                }
                DataSource dataSource = cmrField.getDataSource();
                con = dataSource.getConnection();
                ps = con.prepareStatement(sql);
                for (RelationPair pair : relationData.addedRelations) {
                    JDBCInsertRelationsCommand.setParameters(ps, relationData, pair);
                    int rowsAffected = ps.executeUpdate();
                }
                Object var12_12 = null;
            }
            catch (Exception e) {
                throw new EJBException("Could insert relations into " + cmrField.getQualifiedTableName(), e);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            JDBCUtil.safeClose(ps);
            JDBCUtil.safeClose(con);
            throw throwable;
        }
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(con);
    }

    protected static String getSQL(RelationData relationData) {
        JDBCCMRFieldBridge left = relationData.getLeftCMRField();
        JDBCCMRFieldBridge right = relationData.getRightCMRField();
        StringBuffer sql = new StringBuffer(200);
        sql.append("INSERT INTO ").append(left.getQualifiedTableName());
        sql.append('(');
        SQLUtil.getColumnNamesClause(left.getTableKeyFields(), sql);
        sql.append(", ");
        SQLUtil.getColumnNamesClause(right.getTableKeyFields(), sql);
        sql.append(')');
        sql.append(" VALUES ").append('(');
        SQLUtil.getValuesClause(left.getTableKeyFields(), sql);
        sql.append(", ");
        SQLUtil.getValuesClause(right.getTableKeyFields(), sql);
        sql.append(')');
        return sql.toString();
    }

    protected static void setParameters(PreparedStatement ps, RelationData relationData, RelationPair pair) {
        int index = 1;
        Object leftId = pair.getLeftId();
        JDBCCMPFieldBridge[] leftFields = (JDBCCMPFieldBridge[])relationData.getLeftCMRField().getTableKeyFields();
        for (int i = 0; i < leftFields.length; ++i) {
            index = leftFields[i].setPrimaryKeyParameters(ps, index, leftId);
        }
        Object rightId = pair.getRightId();
        JDBCCMPFieldBridge[] rightFields = (JDBCCMPFieldBridge[])relationData.getRightCMRField().getTableKeyFields();
        for (int i = 0; i < rightFields.length; ++i) {
            index = rightFields[i].setPrimaryKeyParameters(ps, index, rightId);
        }
    }
}

