/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.ejb;

import java.net.URL;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.logging.Logger;
import org.jboss.profileservice.ejb.SecureManagementView;
import org.jboss.profileservice.spi.DeploymentOption;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless(name="SecureDeploymentManager")
@SecurityDomain(value="profileservice", unauthenticatedPrincipal="nobody")
@Remote(value={DeploymentManager.class})
@RolesAllowed(value={"Administrator"})
public class SecureDeploymentManager
implements DeploymentManager {
    static Logger log = Logger.getLogger(SecureManagementView.class);
    @Resource(mappedName="ProfileService")
    private ProfileService profileService;
    private DeploymentManager delegate;

    @PostConstruct
    public void postConstruct() {
        log.debug((Object)"Looking up ProfileService.DeploymentManager");
        this.delegate = this.profileService.getDeploymentManager();
    }

    @PreDestroy
    public void preDestroy() {
        this.delegate = null;
    }

    public DeploymentProgress distribute(String name, URL contentURL, boolean copyContent) throws Exception {
        return this.delegate.distribute(name, contentURL, copyContent);
    }

    public DeploymentProgress distribute(String name, URL contentURL, DeploymentOption ... options) throws Exception {
        return this.delegate.distribute(name, contentURL, options);
    }

    public Collection<ProfileKey> getProfiles() {
        return this.delegate.getProfiles();
    }

    public String[] getRepositoryNames(String[] names) throws Exception {
        return this.delegate.getRepositoryNames(names);
    }

    public boolean isRedeploySupported() {
        return this.delegate.isRedeploySupported();
    }

    public void loadProfile(ProfileKey key) throws Exception {
        this.delegate.loadProfile(key);
    }

    public DeploymentProgress prepare(String ... names) throws Exception {
        return this.delegate.prepare(names);
    }

    public DeploymentProgress redeploy(String name) throws Exception {
        return this.delegate.redeploy(name);
    }

    public void releaseProfile() throws Exception {
        this.delegate.releaseProfile();
    }

    public DeploymentProgress remove(String ... names) throws Exception {
        return this.delegate.remove(names);
    }

    public DeploymentProgress start(String ... names) throws Exception {
        return this.delegate.start(names);
    }

    public DeploymentProgress stop(String ... names) throws Exception {
        return this.delegate.stop(names);
    }
}

