/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist.bytecode;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.bytecode.DuplicateMemberException;
import javassist.util.proxy.RuntimeSupport;
import org.jboss.reflect.plugins.javassist.JavassistConstructor;
import org.jboss.reflect.plugins.javassist.JavassistConstructorInfo;
import org.jboss.reflect.plugins.javassist.JavassistField;
import org.jboss.reflect.plugins.javassist.JavassistFieldInfo;
import org.jboss.reflect.plugins.javassist.JavassistMethod;
import org.jboss.reflect.plugins.javassist.JavassistMethodInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.SignatureKey;
import org.jboss.reflect.plugins.javassist.bytecode.ClassFileWriterContext;
import org.jboss.reflect.plugins.javassist.bytecode.ErrorCheckingMemberFactory;
import org.jboss.reflect.plugins.javassist.bytecode.JavassistConstructorFactory;
import org.jboss.reflect.plugins.javassist.bytecode.JavassistFieldFactory;
import org.jboss.reflect.plugins.javassist.bytecode.JavassistMethodFactory;
import org.jboss.reflect.plugins.javassist.bytecode.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavassistMemberFactory {
    protected static final String OBJECT_NAME = Object.class.getName();
    protected static final String[] THROWABLE_EXCEPTIONS = new String[]{"java/lang/Throwable"};
    protected static final AtomicInteger counter = new AtomicInteger(0);
    private final Class<?> superClass;
    private final boolean debug;
    private String accessedMember;
    private static final ParentLoaderHandler PARENT_LOADER_HANDLER = AccessController.doPrivileged(new PrivilegedAction<ParentLoaderHandler>(){

        @Override
        public ParentLoaderHandler run() {
            ClassLoader loader;
            HashSet<ClassLoader> parents;
            ClassLoader reflectLoader = JavassistMethod.class.getClassLoader();
            if (reflectLoader == null) {
                reflectLoader = ClassLoader.getSystemClassLoader();
            }
            HashSet<ClassLoader> hashSet = parents = (loader = reflectLoader.getParent()) == null ? null : new HashSet<ClassLoader>();
            while (loader != null) {
                parents.add(loader);
                loader = loader.getParent();
            }
            return new ParentLoaderHandler(reflectLoader, parents);
        }
    });

    JavassistMemberFactory(Class<?> superClass, boolean debug) {
        this.superClass = superClass;
        this.debug = debug;
    }

    public static JavassistMethod createJavassistMethod(Class<?> superClass, JavassistMethodInfo method, boolean debug) {
        JavassistMethodFactory factory = new JavassistMethodFactory(superClass, method, debug);
        Class<JavassistMethod> member = factory.makeClass(JavassistMethod.class, (JavassistTypeInfo)method.getDeclaringClass());
        return ErrorCheckingMemberFactory.wrapInErrorChecker(factory.instantiate(member), method);
    }

    public static JavassistConstructor createJavassistConstructor(Class<?> superClass, JavassistConstructorInfo constructor, boolean debug) {
        JavassistConstructorFactory factory = new JavassistConstructorFactory(superClass, constructor, debug);
        Class<JavassistConstructor> member = factory.makeClass(JavassistConstructor.class, (JavassistTypeInfo)constructor.getDeclaringClass());
        return ErrorCheckingMemberFactory.wrapInErrorChecker(factory.instantiate(member), constructor);
    }

    public static JavassistField createJavassistField(Class<?> superClass, JavassistFieldInfo field, boolean debug) {
        JavassistFieldFactory factory = new JavassistFieldFactory(superClass, field, debug);
        Class<JavassistField> member = factory.makeClass(JavassistField.class, field.getDeclaringClass());
        return ErrorCheckingMemberFactory.wrapInErrorChecker(factory.instantiate(member), field);
    }

    protected <T> T instantiate(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> Class<T> makeClass(Class<T> expected, JavassistTypeInfo target) {
        String name = this.getGeneratedClassName();
        ClassFileWriterContext<T> cfwc = new ClassFileWriterContext<T>(name, this.superClass.getName(), expected, this.getInterfaceNames());
        try {
            this.implementMethods(cfwc);
            if (this.debug) {
                this.debugWriteFile(cfwc);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating " + expected.getSimpleName() + " for " + target.getName(), e);
        }
        ClassLoader cl = target.getClassLoaderInternal();
        if (cl == null) {
            cl = SecurityActions.getContextClassLoader();
        }
        return this.toClass(cfwc, target, cl, null);
    }

    private <T> Class<T> toClass(ClassFileWriterContext<T> cfwc, JavassistTypeInfo target, ClassLoader cl, ProtectionDomain domain) {
        ClassLoader actualLoader = JavassistMemberFactory.PARENT_LOADER_HANDLER.getActualLoader(cl);
        ReflectiveOperationException t = null;
        try {
            return cfwc.toClass(actualLoader, domain);
        }
        catch (InvocationTargetException e) {
            t = e;
        }
        catch (IllegalAccessException e) {
            t = e;
        }
        throw new RuntimeException("Error creating " + cfwc.getSimpleType() + " for " + target.getName() + " with classloader " + actualLoader + "(" + cl + ")", t);
    }

    void implementMethods(ClassFileWriterContext<?> cfcw) throws DuplicateMemberException {
        int i = 0;
        while (this.implementMethod(i++, cfcw)) {
        }
    }

    String getAccessedMember() {
        if (this.accessedMember == null) {
            this.accessedMember = this.initAccessedMember();
        }
        return this.accessedMember;
    }

    abstract boolean implementMethod(int var1, ClassFileWriterContext<?> var2);

    abstract String[] getInterfaceNames();

    abstract String getGeneratedClassName();

    abstract String initAccessedMember();

    int countParameterStackSize(int offset, SignatureKey signatureKey) {
        int stacksize = offset;
        String[] params = signatureKey.getParams();
        int n = params.length;
        for (int i = 0; i < n; ++i) {
            ++stacksize;
            if (!signatureKey.isDouble(i) && !signatureKey.isLong(i)) continue;
            ++stacksize;
        }
        return stacksize;
    }

    void debugWriteFile(final ClassFileWriterContext<?> cfwc) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run() throws Exception {
                    FileOutputStream fout = new FileOutputStream(cfwc.getName() + ".class");
                    BufferedOutputStream out = new BufferedOutputStream(fout);
                    try {
                        out.write(cfwc.getBytes());
                    }
                    finally {
                        try {
                            out.close();
                        }
                        catch (Exception exception) {}
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    String getBoxedType(String type) {
        if (type.startsWith("[")) {
            return type.replace('.', '/');
        }
        Boxing boxing = Boxing.getUnboxer(type);
        if (boxing != null) {
            return boxing.getClassName();
        }
        return type;
    }

    void castAndUnbox(ClassFileWriterContext<?> cfwc, String type) {
        if (type.equals(OBJECT_NAME)) {
            return;
        }
        cfwc.addCheckcast(ClassFileWriterContext.jvmClassName(this.getBoxedType(type)));
        Boxing unboxer = Boxing.getUnboxer(type);
        if (unboxer != null) {
            cfwc.addInvokeVirtual(unboxer.getClassName(), unboxer.getUnboxMethodName(), unboxer.getUnboxMethodDescriptor());
        }
    }

    void boxReturnValue(ClassFileWriterContext<?> cfwc, String type) {
        Boxing boxing = Boxing.BOXERS.get(type);
        if (boxing != null) {
            cfwc.addInvokeStatic(boxing.getClassName(), boxing.getBoxMethodName(), boxing.getBoxMethodDescriptor());
        }
    }

    private static class Boxing {
        static final Map<String, Boxing> BOXERS = new HashMap<String, Boxing>();
        private String className;
        private String unboxMethodName;
        private String unboxMethodDescriptor;
        private String boxMethodDescriptor;

        static Boxing getUnboxer(String primitive) {
            return BOXERS.get(primitive);
        }

        public Boxing(String className, String methodName, String unboxMethodDescriptor, String boxMethodDescriptor) {
            this.className = className;
            this.unboxMethodName = methodName;
            this.unboxMethodDescriptor = unboxMethodDescriptor;
            this.boxMethodDescriptor = boxMethodDescriptor;
        }

        String getClassName() {
            return this.className;
        }

        String getUnboxMethodName() {
            return this.unboxMethodName;
        }

        String getUnboxMethodDescriptor() {
            return this.unboxMethodDescriptor;
        }

        String getBoxMethodName() {
            return "valueOf";
        }

        String getBoxMethodDescriptor() {
            return this.boxMethodDescriptor;
        }

        static {
            BOXERS.put("boolean", new Boxing(ClassFileWriterContext.jvmClassName(Boolean.class.getName()), "booleanValue", RuntimeSupport.makeDescriptor((Class[])new Class[0], Boolean.TYPE), RuntimeSupport.makeDescriptor((Class[])new Class[]{Boolean.TYPE}, Boolean.class)));
            BOXERS.put("Z", BOXERS.get("boolean"));
            BOXERS.put("byte", new Boxing(ClassFileWriterContext.jvmClassName(Byte.class.getName()), "byteValue", RuntimeSupport.makeDescriptor((Class[])new Class[0], Byte.TYPE), RuntimeSupport.makeDescriptor((Class[])new Class[]{Byte.TYPE}, Byte.class)));
            BOXERS.put("B", BOXERS.get("byte"));
            BOXERS.put("char", new Boxing(ClassFileWriterContext.jvmClassName(Character.class.getName()), "charValue", RuntimeSupport.makeDescriptor((Class[])new Class[0], Character.TYPE), RuntimeSupport.makeDescriptor((Class[])new Class[]{Character.TYPE}, Character.class)));
            BOXERS.put("C", BOXERS.get("char"));
            BOXERS.put("double", new Boxing(ClassFileWriterContext.jvmClassName(Double.class.getName()), "doubleValue", RuntimeSupport.makeDescriptor((Class[])new Class[0], Double.TYPE), RuntimeSupport.makeDescriptor((Class[])new Class[]{Double.TYPE}, Double.class)));
            BOXERS.put("D", BOXERS.get("double"));
            BOXERS.put("float", new Boxing(ClassFileWriterContext.jvmClassName(Float.class.getName()), "floatValue", RuntimeSupport.makeDescriptor((Class[])new Class[0], Float.TYPE), RuntimeSupport.makeDescriptor((Class[])new Class[]{Float.TYPE}, Float.class)));
            BOXERS.put("F", BOXERS.get("float"));
            BOXERS.put("int", new Boxing(ClassFileWriterContext.jvmClassName(Integer.class.getName()), "intValue", RuntimeSupport.makeDescriptor((Class[])new Class[0], Integer.TYPE), RuntimeSupport.makeDescriptor((Class[])new Class[]{Integer.TYPE}, Integer.class)));
            BOXERS.put("I", BOXERS.get("int"));
            BOXERS.put("long", new Boxing(ClassFileWriterContext.jvmClassName(Long.class.getName()), "longValue", RuntimeSupport.makeDescriptor((Class[])new Class[0], Long.TYPE), RuntimeSupport.makeDescriptor((Class[])new Class[]{Long.TYPE}, Long.class)));
            BOXERS.put("J", BOXERS.get("long"));
            BOXERS.put("short", new Boxing(ClassFileWriterContext.jvmClassName(Short.class.getName()), "shortValue", RuntimeSupport.makeDescriptor((Class[])new Class[0], Short.TYPE), RuntimeSupport.makeDescriptor((Class[])new Class[]{Short.TYPE}, Short.class)));
            BOXERS.put("S", BOXERS.get("short"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParentLoaderHandler {
        final ClassLoader reflectLoader;
        final Set<ClassLoader> parentLoaders;

        public ParentLoaderHandler(ClassLoader reflectLoader, Set<ClassLoader> parentLoaders) {
            if (reflectLoader == null) {
                throw new IllegalArgumentException("Null reflect loader");
            }
            this.reflectLoader = reflectLoader;
            this.parentLoaders = parentLoaders;
        }

        private ClassLoader getActualLoader(ClassLoader loader) {
            if (this.parentLoaders != null && this.parentLoaders.contains(loader)) {
                return this.reflectLoader;
            }
            return loader;
        }
    }
}

