/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode.bytes.asm;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
    }

    static ClassLoader getSystemClassLoader() {
        if (System.getSecurityManager() == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(GetSystemClassLoaderAction.INSTANCE);
    }

    static Class<?> loadClass(final ClassLoader loader, final String name) throws ClassNotFoundException {
        if (System.getSecurityManager() == null) {
            return loader.loadClass(name);
        }
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws Exception {
                    return loader.loadClass(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    static Properties getSystemProperties() {
        if (System.getSecurityManager() == null) {
            return System.getProperties();
        }
        return AccessController.doPrivileged(GetSystemPropertiesAction.INSTANCE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GetSystemPropertiesAction
    implements PrivilegedAction<Properties> {
        static final GetSystemPropertiesAction INSTANCE = new GetSystemPropertiesAction();

        GetSystemPropertiesAction() {
        }

        @Override
        public Properties run() {
            return System.getProperties();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GetSystemClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        static final GetSystemClassLoaderAction INSTANCE = new GetSystemClassLoaderAction();

        GetSystemClassLoaderAction() {
        }

        @Override
        public ClassLoader run() {
            return ClassLoader.getSystemClassLoader();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class GetContextClassLoaderAction
    implements PrivilegedAction<ClassLoader> {
        static final GetContextClassLoaderAction INSTANCE = new GetContextClassLoaderAction();

        GetContextClassLoaderAction() {
        }

        @Override
        public ClassLoader run() {
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

