/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode.bytes.asm;

import java.lang.annotation.Annotation;
import org.jboss.reflect.plugins.bytecode.bytes.BytecodePrimitive;
import org.jboss.reflect.plugins.bytecode.bytes.ClassBytes;
import org.jboss.reflect.plugins.bytecode.bytes.ConstructorBytes;
import org.jboss.reflect.plugins.bytecode.bytes.FieldBytes;
import org.jboss.reflect.plugins.bytecode.bytes.MethodBytes;
import org.jboss.reflect.plugins.bytecode.bytes.PrimitiveBytes;
import org.jboss.reflect.plugins.bytecode.bytes.asm.AsmClassBytes;
import org.jboss.reflect.plugins.bytecode.bytes.asm.SecurityActions;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

class AsmPrimitiveClassBytes
extends JBossObject
implements PrimitiveBytes {
    static final String[] NO_INTERFACES = new String[0];
    static final AsmPrimitiveClassBytes BOOLEAN = new AsmPrimitiveClassBytes(BytecodePrimitive.BOOLEAN);
    static final AsmPrimitiveClassBytes CHAR = new AsmPrimitiveClassBytes(BytecodePrimitive.CHAR);
    static final AsmPrimitiveClassBytes BYTE = new AsmPrimitiveClassBytes(BytecodePrimitive.BYTE);
    static final AsmPrimitiveClassBytes SHORT = new AsmPrimitiveClassBytes(BytecodePrimitive.SHORT);
    static final AsmPrimitiveClassBytes INT = new AsmPrimitiveClassBytes(BytecodePrimitive.INT);
    static final AsmPrimitiveClassBytes LONG = new AsmPrimitiveClassBytes(BytecodePrimitive.LONG);
    static final AsmPrimitiveClassBytes FLOAT = new AsmPrimitiveClassBytes(BytecodePrimitive.FLOAT);
    static final AsmPrimitiveClassBytes DOUBLE = new AsmPrimitiveClassBytes(BytecodePrimitive.DOUBLE);
    static final AsmPrimitiveClassBytes VOID = new AsmPrimitiveClassBytes(BytecodePrimitive.FLOAT);
    final BytecodePrimitive delegate;

    public AsmPrimitiveClassBytes(BytecodePrimitive primitives) {
        this.delegate = primitives;
    }

    public String getJvmName() {
        return this.delegate.getName();
    }

    public String getTypeInfoName() {
        return this.delegate.getName();
    }

    public String getArrayComponentName() {
        return this.delegate.getArrayComponentName();
    }

    public String getValueMethodName() {
        return this.delegate.getValueMethodName();
    }

    public String getWrapperClassName() {
        return this.delegate.getWrapperClassName();
    }

    public PrimitiveBytes getPrimitive() {
        return this;
    }

    public ClassLoader getClassLoader() {
        return SecurityActions.getSystemClassLoader();
    }

    public ClassBytes getComponentType() {
        return null;
    }

    public ConstructorBytes[] getDeclaredConstructorBytes() {
        return AsmClassBytes.NO_CONSTRUCTORS;
    }

    public FieldBytes[] getDeclaredFieldBytes() {
        return AsmClassBytes.NO_FIELDS;
    }

    public MethodBytes[] getDeclaredMethodBytes() {
        return AsmClassBytes.NO_METHODS;
    }

    public String[] getInterfaceJvmNames() {
        return NO_INTERFACES;
    }

    public String[] getInterfaceTypeInfoNames() {
        return NO_INTERFACES;
    }

    public String getSuperClassJvmName() {
        return null;
    }

    public String getSuperClassTypeInfoName() {
        return null;
    }

    public boolean isAnnotation() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public Annotation[] getAnnotations() {
        return AsmClassBytes.NO_ANNOTATIONS;
    }

    public String getGenericSignature() {
        return null;
    }

    public int getModifiers() {
        return 0;
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getJvmName());
    }

    protected void toString(JBossStringBuilder buffer) {
        this.toShortString(buffer);
    }
}

