/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode.accessor.generated;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jboss.reflect.plugins.bytecode.BytecodeConstructorInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeFieldInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeMethodInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeTypeInfo;
import org.jboss.reflect.plugins.bytecode.accessor.ConstructorAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.FieldAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.MethodAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.generated.SecurityActions;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ErrorCheckingMemberFactory {
    ErrorCheckingMemberFactory() {
    }

    static MethodAccessor wrapInErrorChecker(MethodAccessor m, BytecodeMethodInfo method) {
        if (m == null || method == null) {
            throw new IllegalArgumentException("Null method");
        }
        int numParameters = method.getSignatureKey().getParams().length;
        return new GeneratedMethodErrorChecker(m, method, numParameters);
    }

    static ConstructorAccessor wrapInErrorChecker(ConstructorAccessor c, BytecodeConstructorInfo constructor) {
        if (c == null || constructor == null) {
            throw new IllegalArgumentException("Null constructor");
        }
        int numParameters = constructor.getSignatureKey().getParams().length;
        return new GeneratedConstructorErrorChecker(c, constructor, numParameters);
    }

    static FieldAccessor wrapInErrorChecker(FieldAccessor f, BytecodeFieldInfo field) {
        if (f == null) {
            throw new IllegalArgumentException("Null field");
        }
        return new GeneratedFieldErrorChecker(f, field);
    }

    private static boolean checkNumberOfParameters(Object[] args, int numParameters) {
        if (args == null && numParameters > 0) {
            return false;
        }
        return args == null || args.length == numParameters;
    }

    private static void handleWrongParameters(String context, String target, Class<?>[] expected, Object[] args) {
        ArrayList<String> actual = new ArrayList<String>();
        if (args != null) {
            for (Object argument : args) {
                if (argument == null) {
                    actual.add(null);
                    continue;
                }
                actual.add(argument.getClass().getName());
            }
        }
        throw new IllegalArgumentException("Wrong arguments. " + context + " for target " + target + " expected=" + expected + " actual=" + actual);
    }

    private static void handleWrongTarget(Object target, Class<?> expected, String name) {
        throw new IllegalArgumentException("Wrong target for " + name + " " + target.getClass().getName() + " is not a " + expected.getName());
    }

    private static void handleNullTarget(AccessibleObject ao) {
        throw new IllegalArgumentException("Null target calling non-static " + ao);
    }

    private static class GeneratedFieldErrorChecker
    extends ErrorCheckingMemberFactory
    implements FieldAccessor {
        private final FieldAccessor delegate;
        private final BytecodeFieldInfo field;
        private volatile Field real;

        private GeneratedFieldErrorChecker(FieldAccessor delegate, BytecodeFieldInfo field) {
            this.delegate = delegate;
            this.field = field;
        }

        public Object get(Object target) throws Throwable {
            try {
                return this.delegate.get(target);
            }
            catch (ClassCastException e) {
                Field real = this.getRealField();
                if (!this.field.isStatic() && !real.getDeclaringClass().isAssignableFrom(target.getClass())) {
                    ErrorCheckingMemberFactory.handleWrongTarget(target, real.getDeclaringClass(), real.getName());
                }
                throw e;
            }
            catch (NullPointerException e) {
                if (!this.field.isStatic() && target == null) {
                    Field real = this.getRealField();
                    ErrorCheckingMemberFactory.handleNullTarget(real);
                }
                throw e;
            }
        }

        public void set(Object target, Object value) throws Throwable {
            try {
                this.delegate.set(target, value);
            }
            catch (ClassCastException e) {
                Field real = this.getRealField();
                Class<?> type = real.getType();
                if (!this.field.isStatic() && !real.getDeclaringClass().isAssignableFrom(target.getClass())) {
                    ErrorCheckingMemberFactory.handleWrongTarget(target, real.getDeclaringClass(), real.getName());
                }
                if (!type.isAssignableFrom(value.getClass())) {
                    throw new IllegalArgumentException("Wrong arguments. Setting " + real.getName() + " for target " + target + " expected=" + real.getType() + " actual=" + value.getClass());
                }
            }
            catch (NullPointerException e) {
                if (!this.field.isStatic() && target == null) {
                    Field real = this.getRealField();
                    ErrorCheckingMemberFactory.handleNullTarget(real);
                }
                if (this.field.getType().isPrimitive() && value == null) {
                    throw new IllegalArgumentException("Null value setting non-static field. " + this.real);
                }
                throw e;
            }
        }

        private Field getRealField() throws Throwable {
            if (this.real == null) {
                Class<? extends Object> clazz = this.field.getDeclaringClass().getType();
                this.real = SecurityActions.getDeclaredField(clazz, this.field.getName());
            }
            return this.real;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GeneratedConstructorErrorChecker
    extends ErrorCheckingMemberFactory
    implements ConstructorAccessor {
        private final ConstructorAccessor delegate;
        private final BytecodeConstructorInfo constructor;
        private final int numParameters;
        private volatile Constructor<?> real;

        private GeneratedConstructorErrorChecker(ConstructorAccessor delegate, BytecodeConstructorInfo constructor, int numParameters) {
            this.delegate = delegate;
            this.constructor = constructor;
            this.numParameters = numParameters;
        }

        @Override
        public Object newInstance(Object[] args) throws Throwable {
            if (!ErrorCheckingMemberFactory.checkNumberOfParameters(args, this.numParameters)) {
                throw new IllegalArgumentException("Wrong number of parameters for " + this.constructor.getDeclaringClass() + "." + this.constructor.getName() + this.constructor.getDescriptor());
            }
            try {
                return this.delegate.newInstance(args);
            }
            catch (ClassCastException e) {
                Constructor<?> real = this.getRealConstructor();
                Class<?>[] params = real.getParameterTypes();
                for (int i = 0; i < args.length; ++i) {
                    if (params[i].isAssignableFrom(args[i].getClass())) continue;
                    ErrorCheckingMemberFactory.handleWrongParameters("new", Strings.defaultToString((Object)((BytecodeTypeInfo)this.constructor.getDeclaringClass()).getName()), real.getParameterTypes(), args);
                }
                throw e;
            }
            catch (NullPointerException e) {
                TypeInfo[] parameters = this.constructor.getParameterTypes();
                for (int i = 0; i < parameters.length; ++i) {
                    if (!parameters[i].isPrimitive() || args[i] != null) continue;
                    Constructor<?> real = this.getRealConstructor();
                    ErrorCheckingMemberFactory.handleWrongParameters("new", Strings.defaultToString((Object)real.getDeclaringClass().getName()), real.getParameterTypes(), args);
                }
                throw e;
            }
        }

        private Constructor<?> getRealConstructor() throws Throwable {
            if (this.real == null) {
                Class<? extends Object> clazz = ((BytecodeTypeInfo)this.constructor.getDeclaringClass()).getType();
                TypeInfo[] paramTypes = this.constructor.getParameterTypes();
                Class[] params = new Class[paramTypes.length];
                for (int i = 0; i < paramTypes.length; ++i) {
                    params[i] = paramTypes[i].getType();
                }
                this.real = SecurityActions.getDeclaredConstructor(clazz, params);
            }
            return this.real;
        }
    }

    private static class GeneratedMethodErrorChecker
    extends ErrorCheckingMemberFactory
    implements MethodAccessor {
        private final MethodAccessor delegate;
        private final BytecodeMethodInfo method;
        private final int numParameters;
        private volatile Method real;

        private GeneratedMethodErrorChecker(MethodAccessor delegate, BytecodeMethodInfo method, int numParameters) {
            this.delegate = delegate;
            this.method = method;
            this.numParameters = numParameters;
        }

        public Object invoke(Object target, Object[] args) throws Throwable {
            if (!ErrorCheckingMemberFactory.checkNumberOfParameters(args, this.numParameters)) {
                throw new IllegalArgumentException("Wrong number of parameters for " + ((BytecodeTypeInfo)this.method.getDeclaringClass()).getName() + "." + this.method.getName() + this.method.getDescriptor());
            }
            try {
                return this.delegate.invoke(target, args);
            }
            catch (ClassCastException e) {
                Method real = this.getRealMethod();
                if (!this.method.isStatic() && !real.getDeclaringClass().isAssignableFrom(target.getClass())) {
                    ErrorCheckingMemberFactory.handleWrongTarget(target, real.getDeclaringClass(), real.getName());
                }
                Class<?>[] params = real.getParameterTypes();
                for (int i = 0; i < args.length; ++i) {
                    if (params[i].isAssignableFrom(args[i].getClass())) continue;
                    ErrorCheckingMemberFactory.handleWrongParameters(this.method.getName(), Strings.defaultToString((Object)target), real.getParameterTypes(), args);
                }
                throw e;
            }
            catch (NullPointerException e) {
                Method real = this.getRealMethod();
                if (!this.method.isStatic() && target == null) {
                    ErrorCheckingMemberFactory.handleNullTarget(real);
                }
                Class<?>[] parameters = real.getParameterTypes();
                for (int i = 0; i < parameters.length; ++i) {
                    if (!parameters[i].isPrimitive() || args[i] != null) continue;
                    ErrorCheckingMemberFactory.handleWrongParameters(this.method.getName(), Strings.defaultToString((Object)target), real.getParameterTypes(), args);
                }
                throw e;
            }
        }

        private Method getRealMethod() throws Throwable {
            if (this.real == null) {
                Class<? extends Object> clazz = ((BytecodeTypeInfo)this.method.getDeclaringClass()).getType();
                TypeInfo[] paramTypes = this.method.getParameterTypes();
                Class[] params = new Class[paramTypes.length];
                for (int i = 0; i < paramTypes.length; ++i) {
                    params[i] = paramTypes[i].getType();
                }
                this.real = SecurityActions.getDeclaredMethod(clazz, this.method.getName(), params);
            }
            return this.real;
        }
    }
}

