/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode.accessor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Set;
import org.jboss.reflect.plugins.bytecode.BytecodeConstructorInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeFieldInfo;
import org.jboss.reflect.plugins.bytecode.BytecodeMethodInfo;
import org.jboss.reflect.plugins.bytecode.accessor.ConstructorAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.FieldAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.MethodAccessor;
import org.jboss.reflect.plugins.bytecode.accessor.SecurityActions;
import org.jboss.reflect.plugins.bytecode.accessor.generated.GeneratedMemberAccessorFactory;
import org.jboss.reflect.plugins.bytecode.accessor.metrics.MetricsAccessorFactory;
import org.jboss.reflect.plugins.bytecode.accessor.reflect.ReflectAccessorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberAccessorFactory {
    public static final MemberAccessorFactory INSTANCE;
    private static final boolean debug;
    private static final boolean enableMetrics;
    private static final Set<String> forceGenerate;
    protected static final Class<?> MAGIC_ACCESSOR_IMPL;

    private static boolean initBooleanProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return Boolean.getBoolean(name);
            }
        });
    }

    public void addForceGenerate(String s) {
        forceGenerate.add(s);
    }

    public void removeForceGenerate(String s) {
        forceGenerate.remove(s);
    }

    private static Set<String> initForceGenerate(String name) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Set<String>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Set<String> run() throws Exception {
                    String generateFile = System.getProperty(MemberAccessorFactory.class.getName() + ".file", null);
                    HashSet<String> forceGenerate = new HashSet<String>();
                    if (generateFile != null) {
                        File file = new File(generateFile);
                        if (!file.exists()) {
                            throw new IllegalArgumentException("No file called '" + generateFile + "' specified via -D" + MemberAccessorFactory.class.getName() + ".file");
                        }
                        BufferedReader in = null;
                        try {
                            in = new BufferedReader(new FileReader(file));
                            String s = in.readLine();
                            while (s != null) {
                                if ((s = s.trim()).length() > 0) {
                                    forceGenerate.add(s);
                                }
                                s = in.readLine();
                            }
                        }
                        finally {
                            try {
                                in.close();
                            }
                            catch (Exception ignore) {}
                        }
                    }
                    return forceGenerate;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private MemberAccessorFactory() {
    }

    public MethodAccessor createMethod(BytecodeMethodInfo info) throws Throwable {
        MethodAccessor method;
        String sig = info.getDescriptor();
        MethodAccessor methodAccessor = method = this.generateAccessor(sig) ? GeneratedMemberAccessorFactory.generateMethodAccessor(MAGIC_ACCESSOR_IMPL, info, debug) : ReflectAccessorFactory.createMethodAccessor(info);
        if (enableMetrics) {
            method = MetricsAccessorFactory.createMethodAccessor(method, sig);
        }
        return method;
    }

    public ConstructorAccessor createConstructor(BytecodeConstructorInfo info) throws Throwable {
        ConstructorAccessor ctor;
        String sig = info.getDescriptor();
        ConstructorAccessor constructorAccessor = ctor = this.generateAccessor(sig) ? GeneratedMemberAccessorFactory.generateConstructorAccessor(MAGIC_ACCESSOR_IMPL, info, debug) : ReflectAccessorFactory.createConstructorAccessor(info);
        if (enableMetrics) {
            ctor = MetricsAccessorFactory.createConstructorAccessor(ctor, sig);
        }
        return ctor;
    }

    public FieldAccessor createField(BytecodeFieldInfo info) throws Throwable {
        FieldAccessor field;
        String sig = info.getDescriptor();
        FieldAccessor fieldAccessor = field = this.generateAccessor(sig) ? GeneratedMemberAccessorFactory.generateFieldAccessor(MAGIC_ACCESSOR_IMPL, info, debug) : ReflectAccessorFactory.createFieldAccessor(info);
        if (enableMetrics) {
            field = MetricsAccessorFactory.createFieldAccessor(field, sig);
        }
        return field;
    }

    private boolean generateAccessor(String signature) {
        if (forceGenerate.isEmpty()) {
            return true;
        }
        return forceGenerate.contains(signature);
    }

    static {
        debug = MemberAccessorFactory.initBooleanProperty(MemberAccessorFactory.class.getName() + ".debug");
        enableMetrics = MemberAccessorFactory.initBooleanProperty(MemberAccessorFactory.class.getName() + ".enableMetrics");
        forceGenerate = MemberAccessorFactory.initForceGenerate(MemberAccessorFactory.class.getName() + ".file");
        INSTANCE = new MemberAccessorFactory();
        try {
            MAGIC_ACCESSOR_IMPL = SecurityActions.classForName("sun.reflect.MagicAccessorImpl");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

