/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist.bytecode;

import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.ExceptionsAttribute;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.StackMapTable;
import javassist.util.proxy.FactoryHelper;
import javassist.util.proxy.RuntimeSupport;
import org.jboss.reflect.plugins.javassist.JavassistConstructor;
import org.jboss.reflect.plugins.javassist.JavassistField;
import org.jboss.reflect.plugins.javassist.JavassistMethod;
import org.jboss.reflect.plugins.javassist.JavassistUtil;
import org.jboss.reflect.plugins.javassist.bytecode.JavassistConstructorFactory;
import org.jboss.reflect.plugins.javassist.bytecode.JavassistFieldFactory;
import org.jboss.reflect.plugins.javassist.bytecode.JavassistMethodFactory;
import org.jboss.reflect.plugins.javassist.bytecode.SecurityActions;
import org.jboss.util.Strings;
import org.jboss.util.UnreachableStatementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavassistMemberFactory {
    protected static final String OBJECT_NAME = Object.class.getName();
    protected static final String ILLEGAL_ARGUMENT_EXCEPTION_NAME = IllegalArgumentException.class.getName();
    private static final String SHORT_NAME = Short.class.getName();
    private static final String LONG_NAME = Long.class.getName();
    private static final String INTEGER_NAME = Integer.class.getName();
    private static final String FLOAT_NAME = Float.class.getName();
    private static final String DOUBLE_NAME = Double.class.getName();
    private static final String CHARACTER_NAME = Character.class.getName();
    protected static final String BYTE_NAME = Byte.class.getName();
    protected static final String BOOLEAN_NAME = Boolean.class.getName();
    protected static final String ILLEGAL_ARGUMENT_EXCEPTION_CONSTRUCTOR_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[]{String.class}, Void.TYPE);
    protected static final String STRINGBUILDER_TOSTRING_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[0], String.class);
    protected static final String STRINGBUILDER_APPEND_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[]{Object.class}, StringBuilder.class);
    protected static final String STRINGBUILDER_CONSTRUCTOR_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[]{String.class}, Void.TYPE);
    private static final String BOOLEAN_VALUE_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[0], Boolean.TYPE);
    private static final String BYTE_VALUE_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[0], Byte.TYPE);
    private static final String CHAR_VALUE_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[0], Character.TYPE);
    private static final String DOUBLE_VALUE_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[0], Double.TYPE);
    private static final String FLOAT_VALUE_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[0], Float.TYPE);
    private static final String INTEGER_VALUE_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[0], Integer.TYPE);
    private static final String LONG_VALUE_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[0], Long.TYPE);
    private static final String SHORT_VALUE_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[0], Short.TYPE);
    private static final String BOOLEAN_VALUE_OF_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[]{Boolean.TYPE}, Boolean.class);
    private static final String BYTE_VALUE_OF_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[]{Byte.TYPE}, Byte.class);
    private static final String CHARACTER_VALUE_OF_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[]{Character.TYPE}, Character.class);
    private static final String DOUBLE_VALUE_OF_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[]{Double.TYPE}, Double.class);
    private static final String FLOAT_VALUE_OF_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[]{Float.TYPE}, Float.class);
    private static final String INTEGER_VALUE_OF_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[]{Integer.TYPE}, Integer.class);
    private static final String LONG_VALUE_OF_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[]{Long.TYPE}, Long.class);
    private static final String SHORT_VALUE_OF_DESCRIPTOR = RuntimeSupport.makeDescriptor((Class[])new Class[]{Short.TYPE}, Short.class);
    protected static final AtomicInteger counter = new AtomicInteger(0);
    private final Class<?> superClass;
    private final boolean debug;
    private String accessedMember;
    private static final ParentLoaderHandler PARENT_LOADER_HANDLER = AccessController.doPrivileged(new PrivilegedAction<ParentLoaderHandler>(){

        @Override
        public ParentLoaderHandler run() {
            ClassLoader loader;
            HashSet<ClassLoader> parents;
            ClassLoader reflectLoader = JavassistMethod.class.getClassLoader();
            if (reflectLoader == null) {
                reflectLoader = ClassLoader.getSystemClassLoader();
            }
            HashSet<ClassLoader> hashSet = parents = (loader = reflectLoader.getParent()) == null ? null : new HashSet<ClassLoader>();
            while (loader != null) {
                parents.add(loader);
                loader = loader.getParent();
            }
            return new ParentLoaderHandler(reflectLoader, parents);
        }
    });

    JavassistMemberFactory(Class<?> superClass, boolean debug) {
        this.superClass = superClass;
        this.debug = debug;
    }

    public static JavassistMethod createJavassistMethod(Class<?> superClass, CtMethod ctMethod, boolean debug) {
        JavassistMethodFactory factory = new JavassistMethodFactory(superClass, ctMethod, debug);
        Class<JavassistMethod> member = factory.makeClass(JavassistMethod.class, ctMethod.getDeclaringClass());
        return JavassistMemberFactory.wrapInErrorChecker(factory.instantiate(member), ctMethod);
    }

    public static JavassistConstructor createJavassistConstructor(Class<?> superClass, CtConstructor ctConstructor, boolean debug) {
        JavassistConstructorFactory factory = new JavassistConstructorFactory(superClass, ctConstructor, debug);
        Class<JavassistConstructor> member = factory.makeClass(JavassistConstructor.class, ctConstructor.getDeclaringClass());
        return JavassistMemberFactory.wrapInErrorChecker(factory.instantiate(member), ctConstructor);
    }

    public static JavassistField createJavassistField(Class<?> superClass, CtField ctField, boolean debug) {
        JavassistFieldFactory factory = new JavassistFieldFactory(superClass, ctField, debug);
        Class<JavassistField> member = factory.makeClass(JavassistField.class, ctField.getDeclaringClass());
        return JavassistMemberFactory.wrapInErrorChecker(factory.instantiate(member), ctField);
    }

    protected <T> T instantiate(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> Class<T> makeClass(Class<T> expected, CtClass target) {
        ClassFile cf = new ClassFile(false, this.getGeneratedClassName(), this.superClass.getName());
        cf.setAccessFlags(1);
        cf.setInterfaces(this.getInterfaceNames());
        try {
            this.makeConstructors(cf);
            this.implementMethods(cf);
            if (this.debug) {
                this.debugWriteFile(cf);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating " + expected.getSimpleName() + " for " + target.getName(), e);
        }
        ClassLoader cl = target.getClassPool().getClassLoader();
        if (cl == null) {
            cl = SecurityActions.getContextClassLoader();
        }
        return this.toClass(expected, target, cf, cl);
    }

    private <T> Class<T> toClass(Class<T> expected, CtClass target, final ClassFile cf, ClassLoader cl) {
        final ClassLoader actualLoader = JavassistMemberFactory.PARENT_LOADER_HANDLER.getActualLoader(cl);
        Throwable t = null;
        try {
            if (System.getSecurityManager() == null) {
                return FactoryHelper.toClass((ClassFile)cf, (ClassLoader)actualLoader);
            }
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<T>>(){

                @Override
                public Class<T> run() throws Exception {
                    return FactoryHelper.toClass((ClassFile)cf, (ClassLoader)actualLoader);
                }
            });
        }
        catch (CannotCompileException e) {
            t = e;
        }
        catch (PrivilegedActionException e) {
            t = e.getCause();
        }
        throw new RuntimeException("Error creating " + expected.getSimpleName() + " for " + target.getName() + " with classloader " + actualLoader + "(" + cl + ")", t);
    }

    void implementMethods(ClassFile cf) throws DuplicateMemberException {
        MethodInfo minfo;
        int i = 0;
        while ((minfo = this.implementMethod(i++, cf.getConstPool())) != null) {
            cf.addMethod(minfo);
        }
    }

    String getAccessedMember() {
        if (this.accessedMember == null) {
            this.accessedMember = this.initAccessedMember();
        }
        return this.accessedMember;
    }

    abstract MethodInfo implementMethod(int var1, ConstPool var2);

    abstract String[] getInterfaceNames();

    abstract String getGeneratedClassName();

    abstract String initAccessedMember();

    int countParameterStackSize(int offset, CtClass ... params) {
        int stacksize = offset;
        int n = params.length;
        for (int i = 0; i < n; ++i) {
            ++stacksize;
            if (!params[i].equals(CtClass.longType) && !params[i].equals(CtClass.doubleType)) continue;
            ++stacksize;
        }
        return stacksize;
    }

    private void makeConstructors(ClassFile cf) throws CannotCompileException {
        Constructor<?>[] cons = SecurityActions.getDeclaredConstructors(this.superClass);
        for (int i = 0; i < cons.length; ++i) {
            Constructor<?> c = cons[i];
            int mod = c.getModifiers();
            if (Modifier.isFinal((int)mod) || Modifier.isPrivate((int)mod)) continue;
            MethodInfo m = this.makeConstructor(c, cf.getConstPool());
            cf.addMethod(m);
        }
    }

    private MethodInfo makeConstructor(Constructor<?> cons, ConstPool cp) {
        String desc = RuntimeSupport.makeDescriptor((Class[])cons.getParameterTypes(), Void.TYPE);
        MethodInfo minfo = new MethodInfo(cp, "<init>", desc);
        minfo.setAccessFlags(1);
        this.setThrows(minfo, cp, cons.getExceptionTypes());
        Bytecode code = new Bytecode(cp, 0, 0);
        int pc = code.currentPc();
        code.addAload(0);
        int s = this.addLoadParameters(code, cons.getParameterTypes(), 1);
        code.addInvokespecial(this.superClass.getName(), "<init>", desc);
        code.addOpcode(177);
        code.setMaxLocals(s + 1);
        CodeAttribute ca = code.toCodeAttribute();
        minfo.setCodeAttribute(ca);
        StackMapTable.Writer writer = new StackMapTable.Writer(32);
        writer.sameFrame(pc);
        ca.setAttribute(writer.toStackMapTable(cp));
        return minfo;
    }

    void setThrows(MethodInfo minfo, ConstPool cp, Class<?>[] exceptions) {
        if (exceptions.length == 0) {
            return;
        }
        String[] list = new String[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            list[i] = exceptions[i].getName();
        }
        ExceptionsAttribute ea = new ExceptionsAttribute(cp);
        ea.setExceptions(list);
        minfo.setExceptionsAttribute(ea);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void debugWriteFile(ClassFile cf) throws IOException {
        FileOutputStream fout = new FileOutputStream(cf.getName() + ".class");
        DataOutputStream out = new DataOutputStream(fout);
        try {
            cf.write(out);
        }
        finally {
            out.close();
        }
    }

    int addLoadParameters(Bytecode code, Class<?>[] params, int offset) {
        int stacksize = 0;
        int n = params.length;
        for (int i = 0; i < n; ++i) {
            stacksize += this.addLoad(code, stacksize + offset, params[i]);
        }
        return stacksize;
    }

    int addLoad(Bytecode code, int index, Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Long.TYPE) {
                code.addLload(index);
                return 2;
            }
            if (type == Float.TYPE) {
                code.addFload(index);
            } else {
                if (type == Double.TYPE) {
                    code.addDload(index);
                    return 2;
                }
                code.addIload(index);
            }
        } else {
            code.addAload(index);
        }
        return 1;
    }

    String getBoxedType(CtClass type) {
        if (type.isArray()) {
            return Descriptor.of((CtClass)type);
        }
        if (type.isPrimitive()) {
            if (CtClass.booleanType.equals(type)) {
                return BOOLEAN_NAME;
            }
            if (CtClass.byteType.equals(type)) {
                return BYTE_NAME;
            }
            if (CtClass.charType.equals(type)) {
                return CHARACTER_NAME;
            }
            if (CtClass.doubleType.equals(type)) {
                return DOUBLE_NAME;
            }
            if (CtClass.floatType.equals(type)) {
                return FLOAT_NAME;
            }
            if (CtClass.intType.equals(type)) {
                return INTEGER_NAME;
            }
            if (CtClass.longType.equals(type)) {
                return LONG_NAME;
            }
            if (CtClass.shortType.equals(type)) {
                return SHORT_NAME;
            }
            throw new UnreachableStatementException();
        }
        return type.getName();
    }

    String getArrayType(CtClass type) {
        StringBuilder buf = new StringBuilder();
        while (type.isArray()) {
            buf.append("L");
            try {
                type = type.getComponentType();
            }
            catch (NotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        buf.append(type.getName());
        buf.append(";");
        return buf.toString();
    }

    void castAndUnbox(Bytecode code, CtClass type) {
        if (type.getName().equals(OBJECT_NAME)) {
            return;
        }
        code.addCheckcast(this.getBoxedType(type));
        if (type.isPrimitive()) {
            if (CtClass.booleanType.equals(type)) {
                code.addInvokevirtual(BOOLEAN_NAME, "booleanValue", BOOLEAN_VALUE_DESCRIPTOR);
                return;
            }
            if (CtClass.byteType.equals(type)) {
                code.addInvokevirtual(BYTE_NAME, "byteValue", BYTE_VALUE_DESCRIPTOR);
                return;
            }
            if (CtClass.charType.equals(type)) {
                code.addInvokevirtual(CHARACTER_NAME, "charValue", CHAR_VALUE_DESCRIPTOR);
                return;
            }
            if (CtClass.doubleType.equals(type)) {
                code.addInvokevirtual(DOUBLE_NAME, "doubleValue", DOUBLE_VALUE_DESCRIPTOR);
                return;
            }
            if (CtClass.floatType.equals(type)) {
                code.addInvokevirtual(FLOAT_NAME, "floatValue", FLOAT_VALUE_DESCRIPTOR);
                return;
            }
            if (CtClass.intType.equals(type)) {
                code.addInvokevirtual(INTEGER_NAME, "intValue", INTEGER_VALUE_DESCRIPTOR);
                return;
            }
            if (CtClass.longType.equals(type)) {
                code.addInvokevirtual(LONG_NAME, "longValue", LONG_VALUE_DESCRIPTOR);
                return;
            }
            if (CtClass.shortType.equals(type)) {
                code.addInvokevirtual(SHORT_NAME, "shortValue", SHORT_VALUE_DESCRIPTOR);
                return;
            }
            throw new UnreachableStatementException();
        }
    }

    void boxReturnValue(Bytecode code, CtClass type) {
        if (type.isPrimitive()) {
            if (CtClass.booleanType.equals(type)) {
                code.addInvokestatic(BOOLEAN_NAME, "valueOf", BOOLEAN_VALUE_OF_DESCRIPTOR);
                return;
            }
            if (CtClass.byteType.equals(type)) {
                code.addInvokestatic(BYTE_NAME, "valueOf", BYTE_VALUE_OF_DESCRIPTOR);
                return;
            }
            if (CtClass.charType.equals(type)) {
                code.addInvokestatic(CHARACTER_NAME, "valueOf", CHARACTER_VALUE_OF_DESCRIPTOR);
                return;
            }
            if (CtClass.doubleType.equals(type)) {
                code.addInvokestatic(DOUBLE_NAME, "valueOf", DOUBLE_VALUE_OF_DESCRIPTOR);
                return;
            }
            if (CtClass.floatType.equals(type)) {
                code.addInvokestatic(FLOAT_NAME, "valueOf", FLOAT_VALUE_OF_DESCRIPTOR);
                return;
            }
            if (CtClass.intType.equals(type)) {
                code.addInvokestatic(INTEGER_NAME, "valueOf", INTEGER_VALUE_OF_DESCRIPTOR);
                return;
            }
            if (CtClass.longType.equals(type)) {
                code.addInvokestatic(LONG_NAME, "valueOf", LONG_VALUE_OF_DESCRIPTOR);
                return;
            }
            if (CtClass.shortType.equals(type)) {
                code.addInvokestatic(SHORT_NAME, "valueOf", SHORT_VALUE_OF_DESCRIPTOR);
                return;
            }
            throw new UnreachableStatementException();
        }
    }

    private static JavassistMethod wrapInErrorChecker(JavassistMethod m, CtMethod method) {
        if (m == null || method == null) {
            throw new IllegalArgumentException("Null method");
        }
        int numParameters = 0;
        try {
            numParameters = method.getParameterTypes().length;
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Could not load the parameters for " + method);
        }
        return new ErrorCheckingJavassistMethod(m, method, numParameters);
    }

    private static JavassistConstructor wrapInErrorChecker(JavassistConstructor c, CtConstructor constructor) {
        if (c == null || constructor == null) {
            throw new IllegalArgumentException("Null constructor");
        }
        int numParameters = 0;
        try {
            numParameters = constructor.getParameterTypes().length;
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Could not load the parameters for " + constructor);
        }
        return new ErrorCheckingJavassistConstructor(c, constructor, numParameters);
    }

    private static JavassistField wrapInErrorChecker(JavassistField f, CtField field) {
        if (f == null) {
            throw new IllegalArgumentException("Null field");
        }
        return new ErrorCheckingJavassistField(f, field);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParentLoaderHandler {
        final ClassLoader reflectLoader;
        final Set<ClassLoader> parentLoaders;

        public ParentLoaderHandler(ClassLoader reflectLoader, Set<ClassLoader> parentLoaders) {
            if (reflectLoader == null) {
                throw new IllegalArgumentException("Null reflect loader");
            }
            this.reflectLoader = reflectLoader;
            this.parentLoaders = parentLoaders;
        }

        private ClassLoader getActualLoader(ClassLoader loader) {
            if (this.parentLoaders != null && this.parentLoaders.contains(loader)) {
                return this.reflectLoader;
            }
            return loader;
        }
    }

    private static class ErrorCheckingJavassistField
    extends ErrorChecker
    implements JavassistField {
        private final JavassistField delegate;
        private final CtField ctField;

        private ErrorCheckingJavassistField(JavassistField delegate, CtField ctField) {
            this.delegate = delegate;
            this.ctField = ctField;
        }

        public Object get(Object target) throws Throwable {
            try {
                return this.delegate.get(target);
            }
            catch (ClassCastException e) {
                Field field = JavassistUtil.ctFieldToField(this.ctField);
                if (!this.isStatic((CtMember)this.ctField) && !field.getDeclaringClass().isAssignableFrom(target.getClass())) {
                    this.handleWrongTarget(target, field.getDeclaringClass(), field.getName());
                }
                throw e;
            }
            catch (NullPointerException e) {
                Field field = JavassistUtil.ctFieldToField(this.ctField);
                if (!this.isStatic((CtMember)this.ctField) && target == null) {
                    this.handleNullTarget(field);
                }
                throw e;
            }
        }

        public void set(Object target, Object value) throws Throwable {
            try {
                this.delegate.set(target, value);
            }
            catch (ClassCastException e) {
                Field field = JavassistUtil.ctFieldToField(this.ctField);
                Class<?> type = field.getType();
                if (!this.isStatic((CtMember)this.ctField) && !field.getDeclaringClass().isAssignableFrom(target.getClass())) {
                    this.handleWrongTarget(target, field.getDeclaringClass(), field.getName());
                }
                if (!type.isAssignableFrom(value.getClass())) {
                    throw new IllegalArgumentException("Wrong arguments. Setting " + field.getName() + " for target " + target + " expected=" + field.getType() + " actual=" + value.getClass());
                }
            }
            catch (NullPointerException e) {
                Field field = JavassistUtil.ctFieldToField(this.ctField);
                if (!this.isStatic((CtMember)this.ctField) && target == null) {
                    this.handleNullTarget(field);
                }
                if (this.ctField.getType().isPrimitive() && value == null) {
                    throw new IllegalArgumentException("Null value setting non-static field. " + field);
                }
                throw e;
            }
        }
    }

    private static class ErrorCheckingJavassistConstructor
    extends ErrorChecker
    implements JavassistConstructor {
        private final JavassistConstructor delegate;
        private final CtConstructor ctConstructor;
        private final int numParameters;

        private ErrorCheckingJavassistConstructor(JavassistConstructor delegate, CtConstructor ctConstructor, int numParameters) {
            this.delegate = delegate;
            this.ctConstructor = ctConstructor;
            this.numParameters = numParameters;
        }

        public Object newInstance(Object[] args) throws Throwable {
            if (!this.checkNumberOfParameters(args, this.numParameters)) {
                throw new IllegalArgumentException("Wrong number of parameters for " + this.ctConstructor.getDeclaringClass() + "." + this.ctConstructor.getName() + this.ctConstructor.getSignature());
            }
            try {
                return this.delegate.newInstance(args);
            }
            catch (ClassCastException e) {
                Constructor<?> constructor = JavassistUtil.ctConstructorToConstructor(this.ctConstructor);
                Class<?>[] params = constructor.getParameterTypes();
                for (int i = 0; i < args.length; ++i) {
                    if (params[i].isAssignableFrom(args[i].getClass())) continue;
                    this.handleWrongParameters("new", Strings.defaultToString((Object)this.ctConstructor.getDeclaringClass().getName()), constructor.getParameterTypes(), args);
                }
                throw e;
            }
            catch (NullPointerException e) {
                CtClass[] parameters = this.ctConstructor.getParameterTypes();
                for (int i = 0; i < parameters.length; ++i) {
                    if (!parameters[i].isPrimitive() || args[i] != null) continue;
                    Constructor<?> constructor = JavassistUtil.ctConstructorToConstructor(this.ctConstructor);
                    this.handleWrongParameters("new", Strings.defaultToString((Object)this.ctConstructor.getDeclaringClass().getName()), constructor.getParameterTypes(), args);
                }
                throw e;
            }
        }
    }

    private static class ErrorCheckingJavassistMethod
    extends ErrorChecker
    implements JavassistMethod {
        private final JavassistMethod delegate;
        private final CtMethod ctMethod;
        private final int numParameters;

        private ErrorCheckingJavassistMethod(JavassistMethod delegate, CtMethod ctMethod, int numParameters) {
            this.delegate = delegate;
            this.ctMethod = ctMethod;
            this.numParameters = numParameters;
        }

        public Object invoke(Object target, Object[] args) throws Throwable {
            if (!this.checkNumberOfParameters(args, this.numParameters)) {
                throw new IllegalArgumentException("Wrong number of parameters for " + this.ctMethod.getDeclaringClass() + "." + this.ctMethod.getName() + this.ctMethod.getSignature());
            }
            try {
                return this.delegate.invoke(target, args);
            }
            catch (ClassCastException e) {
                Method method = JavassistUtil.ctMethodToMethod(this.ctMethod);
                if (!this.isStatic((CtMember)this.ctMethod) && !method.getDeclaringClass().isAssignableFrom(target.getClass())) {
                    this.handleWrongTarget(target, method.getDeclaringClass(), method.getName());
                }
                Class<?>[] params = method.getParameterTypes();
                for (int i = 0; i < args.length; ++i) {
                    if (params[i].isAssignableFrom(args[i].getClass())) continue;
                    this.handleWrongParameters(method.getName(), Strings.defaultToString((Object)target), method.getParameterTypes(), args);
                }
                throw e;
            }
            catch (NullPointerException e) {
                Method method = JavassistUtil.ctMethodToMethod(this.ctMethod);
                if (!this.isStatic((CtMember)this.ctMethod) && target == null) {
                    this.handleNullTarget(method);
                }
                CtClass[] parameters = this.ctMethod.getParameterTypes();
                for (int i = 0; i < parameters.length; ++i) {
                    if (!parameters[i].isPrimitive() || args[i] != null) continue;
                    this.handleWrongParameters(method.getName(), Strings.defaultToString((Object)target), method.getParameterTypes(), args);
                }
                throw e;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorChecker {
        private ErrorChecker() {
        }

        protected boolean checkNumberOfParameters(Object[] args, int numParameters) {
            if (args == null && numParameters > 0) {
                return false;
            }
            return args == null || args.length == numParameters;
        }

        protected boolean isStatic(CtMember member) {
            return Modifier.isStatic((int)member.getModifiers());
        }

        protected void handleWrongParameters(String context, String target, Class<?>[] expected, Object[] args) {
            ArrayList<String> actual = new ArrayList<String>();
            if (args != null) {
                for (Object argument : args) {
                    if (argument == null) {
                        actual.add(null);
                        continue;
                    }
                    actual.add(argument.getClass().getName());
                }
            }
            throw new IllegalArgumentException("Wrong arguments. " + context + " for target " + target + " expected=" + expected + " actual=" + actual);
        }

        protected void handleWrongTarget(Object target, Class<?> expected, String name) {
            throw new IllegalArgumentException("Wrong target for " + name + " " + target.getClass().getName() + " is not a " + expected.getName());
        }

        protected void handleNullTarget(AccessibleObject ao) {
            throw new IllegalArgumentException("Null target calling non-static " + ao);
        }
    }
}

