/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.introspection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import org.jboss.reflect.plugins.MethodInfoImpl;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;

public class ReflectMethodInfoImpl
extends MethodInfoImpl {
    private static final long serialVersionUID = 2L;
    private static Permission accessCheck = new ReflectPermission("suppressAccessChecks");
    protected transient Method method;

    public ReflectMethodInfoImpl() {
    }

    public ReflectMethodInfoImpl(AnnotationValue[] annotations, String name, TypeInfo returnType, TypeInfo[] parameterTypes, AnnotationValue[][] parameterAnnotations, ClassInfo[] exceptionTypes, int modifiers, ClassInfo declaring) {
        super(annotations, name, returnType, parameterTypes, parameterAnnotations, exceptionTypes, modifiers, declaring);
    }

    public ReflectMethodInfoImpl(AnnotationValue[] annotations, String name, TypeInfo returnType, ParameterInfo[] parameters, ClassInfo[] exceptionTypes, int modifiers, ClassInfo declaring) {
        super(annotations, name, returnType, parameters, exceptionTypes, modifiers, declaring);
    }

    public void setMethod(Method method) {
        boolean isDeclaringClassPublic = true;
        if (method != null) {
            this.accessCheck(Modifier.isPublic(method.getModifiers()));
            isDeclaringClassPublic = ReflectMethodInfoImpl.isDeclaringClassPublic(method);
            this.accessCheck(isDeclaringClassPublic);
        }
        this.method = method;
        if (!(method == null || this.isPublic() && isDeclaringClassPublic)) {
            this.setAccessible();
        }
    }

    public Method getMethod() {
        this.accessCheck();
        return this.method;
    }

    protected static boolean isDeclaringClassPublic(Method method) {
        Class<?> owner = method.getDeclaringClass();
        return Modifier.isPublic(owner.getModifiers());
    }

    protected final void accessCheck() {
        this.accessCheck(this.isPublic() && (this.method == null || ReflectMethodInfoImpl.isDeclaringClassPublic(this.method)));
    }

    protected final void accessCheck(boolean isPublic) {
        SecurityManager sm;
        if (!isPublic && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(accessCheck);
        }
    }

    public Object invoke(Object target, Object[] args) throws Throwable {
        this.accessCheck();
        return ReflectionUtils.invoke(this.method, target, args);
    }

    private void readObject(ObjectInputStream oistream) throws IOException, ClassNotFoundException, NoSuchMethodException {
        oistream.defaultReadObject();
        int length = this.parameterTypes != null ? this.parameterTypes.length : 0;
        Class[] classes = new Class[length];
        for (int i = 0; i < length; ++i) {
            classes[i] = this.parameterTypes[i].getType();
        }
        this.method = ReflectionUtils.findExactMethod(this.getDeclaringClass().getType(), this.name, classes);
    }

    private void setAccessible() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            this.method.setAccessible(true);
        } else {
            AccessController.doPrivileged(new SetAccessible());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetAccessible
    implements PrivilegedAction<Object> {
        private SetAccessible() {
        }

        @Override
        public Object run() {
            ReflectMethodInfoImpl.this.method.setAccessible(true);
            return null;
        }
    }
}

