/*
* JBoss, Home of Professional Open Source.
* Copyright 2006, Red Hat Middleware LLC, and individual contributors
* as indicated by the @author tags. See the copyright.txt file in the
* distribution for a full listing of individual contributors. 
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.reflect.plugins.javassist.defaultmember;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;

import org.jboss.reflect.plugins.introspection.ReflectionUtils;
import org.jboss.reflect.plugins.javassist.JavassistConstructor;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision: 1.1 $
 */
class DefaultJavassistConstructor implements JavassistConstructor
{
   private final Constructor<?> ctor;

   DefaultJavassistConstructor(Constructor<?> ctor)
   {
      this.ctor = ctor;
      if (ctor != null && !Modifier.isPublic(ctor.getModifiers()) || !Modifier.isPublic(ctor.getDeclaringClass().getModifiers()))
         setAccessible();

   }

   public Object newInstance(Object[] args) throws Throwable
   {
      return ReflectionUtils.newInstance(ctor, args);
   }
   
   /**
    * Set method accessible to true
    */
   private void setAccessible()
   {
      SecurityManager sm = System.getSecurityManager();
      if (sm == null)
         ctor.setAccessible(true);
      else
         AccessController.doPrivileged(new SetAccessible());
   }

   /**
    * Set accessible privileged block
    */
   private class SetAccessible implements PrivilegedAction<Object>
   {
      public Object run()
      {
         ctor.setAccessible(true);
         return null;
      }
   }


}
