/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.reflect.spi.ProgressionConvertor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleProgressionConvertor
implements ProgressionConvertor {
    @Override
    public boolean canProgress(Class<? extends Object> target, Class<? extends Object> source) {
        if (target == null || source == null || BigInteger.class == target || BigDecimal.class == target) {
            return false;
        }
        boolean ipnbt = target.isPrimitive() && target != Boolean.TYPE && target != Character.TYPE;
        boolean ipnbs = source.isPrimitive() && source != Boolean.TYPE && source != Character.TYPE;
        boolean targetIsNumber = Number.class.isAssignableFrom(target);
        boolean sourceIsNumber = Number.class.isAssignableFrom(source);
        return !(!ipnbt && !targetIsNumber || !ipnbs && !sourceIsNumber);
    }

    @Override
    public Object doProgression(Class<? extends Object> target, Object value) throws Throwable {
        if (value == null || target == value.getClass()) {
            return value;
        }
        if (!this.canProgress(target, value.getClass())) {
            throw new IllegalArgumentException("This convertor only handles Numbers: " + target + "/" + value);
        }
        Number source = (Number)value;
        if (Byte.class == target || Byte.TYPE == target) {
            return source.byteValue();
        }
        if (Double.class == target || Double.TYPE == target) {
            return source.doubleValue();
        }
        if (Float.class == target || Float.TYPE == target) {
            return Float.valueOf(source.floatValue());
        }
        if (Integer.class == target || Integer.TYPE == target) {
            return source.intValue();
        }
        if (Long.class == target || Long.TYPE == target) {
            return source.longValue();
        }
        if (Short.class == target || Short.TYPE == target) {
            return source.shortValue();
        }
        if (AtomicInteger.class == target) {
            return new AtomicInteger(source.intValue());
        }
        if (AtomicLong.class == target) {
            return new AtomicLong(source.longValue());
        }
        throw new IllegalArgumentException("Unsupported Number subclass: " + target);
    }
}

