/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.config.plugins;

import java.lang.reflect.Type;
import org.jboss.beans.info.spi.BeanAccessMode;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.BeanInfoFactory;
import org.jboss.classadapter.spi.ClassAdapter;
import org.jboss.classadapter.spi.ClassAdapterFactory;
import org.jboss.config.spi.Configuration;
import org.jboss.config.spi.ConfigurationPermission;
import org.jboss.joinpoint.spi.JoinpointFactoryBuilder;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.reflect.spi.TypeInfoFactory;
import org.jboss.util.NestedRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfiguration
implements Configuration {
    private BeanInfoFactory beanInfoFactory;
    private ClassAdapterFactory classAdapterFactory;
    private TypeInfoFactory typeInfoFactory;
    private JoinpointFactoryBuilder joinpointFactoryBuilder;

    @Override
    public BeanInfo getBeanInfo(String className, ClassLoader cl) throws ClassNotFoundException {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(className, cl);
        return this.getBeanInfoFactory().getBeanInfo(classAdapter);
    }

    @Override
    public BeanInfo getBeanInfo(Class<?> clazz) {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(clazz);
        return this.getBeanInfoFactory().getBeanInfo(classAdapter);
    }

    @Override
    public BeanInfo getBeanInfo(TypeInfo typeInfo) {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(typeInfo);
        return this.getBeanInfoFactory().getBeanInfo(classAdapter);
    }

    @Override
    public BeanInfo getBeanInfo(String className, ClassLoader cl, BeanAccessMode accessMode) throws ClassNotFoundException {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(className, cl);
        return this.getBeanInfoFactory().getBeanInfo(classAdapter, accessMode);
    }

    @Override
    public BeanInfo getBeanInfo(Class<?> clazz, BeanAccessMode accessMode) {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(clazz);
        return this.getBeanInfoFactory().getBeanInfo(classAdapter, accessMode);
    }

    @Override
    public BeanInfo getBeanInfo(TypeInfo typeInfo, BeanAccessMode accessMode) {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(typeInfo);
        return this.getBeanInfoFactory().getBeanInfo(classAdapter, accessMode);
    }

    @Override
    public ClassInfo getClassInfo(String className, ClassLoader cl) throws ClassNotFoundException {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(className, cl);
        return classAdapter.getClassInfo();
    }

    @Override
    public ClassInfo getClassInfo(Class<?> clazz) {
        ClassAdapter classAdapter = this.getClassAdapterFactory().getClassAdapter(clazz);
        return classAdapter.getClassInfo();
    }

    @Override
    public TypeInfo getTypeInfo(Type type) {
        return this.getTypeInfoFactory().getTypeInfo(type);
    }

    @Override
    public TypeInfo getTypeInfo(String type, ClassLoader cl) throws ClassNotFoundException {
        return this.getTypeInfoFactory().getTypeInfo(type, cl);
    }

    @Override
    public TypeInfoFactory getTypeInfoFactory() {
        if (this.typeInfoFactory == null) {
            try {
                this.typeInfoFactory = this.createDefaultTypeInfoFactory();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new NestedRuntimeException("Cannot create TypeInfoFactory", t);
            }
        }
        return this.typeInfoFactory;
    }

    @Override
    public JoinpointFactoryBuilder getJoinpointFactoryBuilder() {
        if (this.joinpointFactoryBuilder == null) {
            try {
                this.joinpointFactoryBuilder = this.createDefaultJoinpointFactoryBuilder();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new NestedRuntimeException("Cannot create JoinpointFactoryBuilder", t);
            }
        }
        return this.joinpointFactoryBuilder;
    }

    @Override
    public void setBeanInfoFactory(BeanInfoFactory beanInfoFactory) {
        this.checkPermissionName("beanInfoFactory");
        this.beanInfoFactory = beanInfoFactory;
    }

    @Override
    public void setClassAdapterFactory(ClassAdapterFactory classAdapterFactory) {
        this.checkPermissionName("classAdapterFactory");
        this.classAdapterFactory = classAdapterFactory;
    }

    @Override
    public void setTypeInfoFactory(TypeInfoFactory typeInfoFactory) {
        this.checkPermissionName("typeInfoFactory");
        this.typeInfoFactory = typeInfoFactory;
    }

    @Override
    public void setJoinpointFactoryBuilder(JoinpointFactoryBuilder joinpointFactoryBuilder) {
        this.checkPermissionName("joinpointFactoryBuilder");
        this.joinpointFactoryBuilder = joinpointFactoryBuilder;
    }

    protected BeanInfoFactory getBeanInfoFactory() {
        if (this.beanInfoFactory == null) {
            try {
                this.beanInfoFactory = this.createDefaultBeanInfoFactory();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException("Error creating bean info factory");
            }
        }
        return this.beanInfoFactory;
    }

    protected ClassAdapterFactory getClassAdapterFactory() {
        if (this.classAdapterFactory == null) {
            try {
                this.classAdapterFactory = this.createDefaultClassAdapterFactory();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException("Error creating class adapter");
            }
        }
        return this.classAdapterFactory;
    }

    protected abstract BeanInfoFactory createDefaultBeanInfoFactory() throws Throwable;

    protected abstract ClassAdapterFactory createDefaultClassAdapterFactory() throws Throwable;

    protected abstract TypeInfoFactory createDefaultTypeInfoFactory() throws Throwable;

    protected abstract JoinpointFactoryBuilder createDefaultJoinpointFactoryBuilder() throws Throwable;

    private void checkPermissionName(String name) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new ConfigurationPermission(name));
        }
    }
}

