/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.extension.jacoco.client;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jacoco.core.data.ExecutionDataReader;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.ExecutionDataWriter;
import org.jacoco.core.data.IExecutionDataVisitor;
import org.jacoco.core.data.ISessionInfoVisitor;
import org.jacoco.core.data.SessionInfoStore;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.extension.jacoco.CoverageDataCommand;

public class CoverageDataReceiver {
    private static final String TARGET_FOLDER = "target/";
    private static final String TARGET_FILE = "jacoco.exec";

    public void storeCoverageData(@Observes CoverageDataCommand coverageDataCommandEvent) {
        try {
            ExecutionDataStore dataStore = new ExecutionDataStore();
            SessionInfoStore sessionStore = new SessionInfoStore();
            this.read(new ByteArrayInputStream(coverageDataCommandEvent.getCoverageDate()), (IExecutionDataVisitor)dataStore, (ISessionInfoVisitor)sessionStore);
            File targetDirectory = new File(TARGET_FOLDER);
            targetDirectory.mkdirs();
            File targetFile = new File(targetDirectory, TARGET_FILE);
            if (targetFile.exists()) {
                this.read(new FileInputStream(targetFile), (IExecutionDataVisitor)dataStore, (ISessionInfoVisitor)sessionStore);
            }
            this.write(new FileOutputStream(targetFile), dataStore, sessionStore);
            coverageDataCommandEvent.setResult("SUCCESS");
        }
        catch (Exception e) {
            coverageDataCommandEvent.setResult("FAILURE");
            e.printStackTrace();
        }
    }

    private void read(InputStream stream, IExecutionDataVisitor executionDataVisitor, ISessionInfoVisitor sessionVisitor) throws IOException {
        block4: {
            ExecutionDataReader reader = new ExecutionDataReader(stream);
            reader.setExecutionDataVisitor(executionDataVisitor);
            reader.setSessionInfoVisitor(sessionVisitor);
            try {
                reader.read();
            }
            catch (IOException e) {
                if (stream == null) break block4;
                try {
                    stream.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    private void write(OutputStream stream, ExecutionDataStore executionData, SessionInfoStore sessionStore) {
        block4: {
            try {
                ExecutionDataWriter writer = new ExecutionDataWriter(stream);
                executionData.accept((IExecutionDataVisitor)writer);
                sessionStore.accept((ISessionInfoVisitor)writer);
                writer.flush();
            }
            catch (IOException e) {
                if (stream == null) break block4;
                try {
                    stream.close();
                }
                catch (IOException e2) {
                    e.printStackTrace();
                }
            }
        }
    }
}

