/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.spi.client.protocol.metadata;

import java.net.URI;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;

public class Servlet {
    private String name;
    private String contextRoot;
    private HTTPContext context;

    public Servlet(String name, String contextRoot) {
        this.name = name;
        this.contextRoot = this.cleanContextRoot(contextRoot);
    }

    void setParent(HTTPContext context) {
        this.context = context;
    }

    public String getName() {
        return this.name;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    private String cleanContextRoot(String contextRoot) {
        if (!contextRoot.startsWith("/")) {
            return "/" + contextRoot;
        }
        return contextRoot;
    }

    public URI getBaseURI() {
        return URI.create("http://" + this.context.getHost() + ":" + this.context.getPort() + this.contextRoot + "/");
    }

    public URI getFullURI() {
        return URI.create("http://" + this.context.getHost() + ":" + this.context.getPort() + this.contextRoot + "/" + this.name);
    }

    public String toString() {
        return "Servlet [name=" + this.name + ", contextRoot=" + this.contextRoot + "]";
    }
}

