/*
 * Decompiled with CFR 0.152.
 */
package org.javers.common.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collector;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.property.MissingProperty;

public class Sets {
    private Sets() {
    }

    public static Set wrapNull(Object set) {
        if (set == null || set == MissingProperty.INSTANCE || !(set instanceof Set)) {
            return Collections.emptySet();
        }
        return (Set)set;
    }

    public static <E> Set<E> intersection(Set<E> first, Set<E> second) {
        if (first == null || second == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<E> intersection = new HashSet<E>();
        for (E e : first) {
            if (!second.contains(e)) continue;
            intersection.add(e);
        }
        return intersection;
    }

    public static <E> Set<E> xor(Set<E> first, Set<E> second) {
        Set<E> xor = Sets.difference(first, second);
        xor.addAll(Sets.difference(second, first));
        return xor;
    }

    public static <E> Set<E> difference(Set<E> first, Set<E> second) {
        if (first == null || first.size() == 0) {
            return new HashSet();
        }
        if (second == null || second.size() == 0) {
            return first;
        }
        HashSet<E> difference = new HashSet<E>(first);
        difference.removeAll(second);
        return difference;
    }

    public static <E> Collection<E> difference(Set<E> first, Set<E> second, Function<E, Integer> hasher) {
        if (first == null || first.size() == 0) {
            return Collections.emptyList();
        }
        if (second == null || second.size() == 0) {
            return first;
        }
        HashMap map = new HashMap();
        first.stream().forEach(e -> map.put((Integer)hasher.apply(e), e));
        second.stream().forEach(e -> map.remove(hasher.apply(e)));
        return Collections.unmodifiableCollection(map.values());
    }

    public static <E> Set<E> asSet(E ... elements) {
        return Sets.asSet(Arrays.asList(elements));
    }

    public static <E> Set<E> asSet(Collection<E> elements) {
        if (elements == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<E>(elements));
    }

    public static <F, T> Set<T> transform(Set<F> input, Function<F, T> transformation) {
        Validate.argumentsAreNotNull(input, transformation);
        return input.stream().map(transformation::apply).collect(Sets.toImmutableSet());
    }

    private static <E> Set<E> nullSafe(Set<E> set) {
        if (set == null) {
            return Collections.EMPTY_SET;
        }
        return set;
    }

    public static <T> Map<Integer, T> asMap(Set<T> input) {
        if (input == null) {
            return null;
        }
        HashMap<Integer, T> result = new HashMap<Integer, T>();
        int i = 0;
        for (T element : input) {
            result.put(i, element);
            ++i;
        }
        return result;
    }

    public static <t> Collector<t, Set<t>, Set<t>> toImmutableSet() {
        return Collector.of(HashSet::new, Set::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Collections::unmodifiableSet, new Collector.Characteristics[0]);
    }

    public static <T> Set<T> join(Set<T> a, Set<T> b) {
        if (a == null || a.size() == 0) {
            return b;
        }
        if (b == null || b.size() == 0) {
            return a;
        }
        HashSet<T> result = new HashSet<T>(a);
        result.addAll(b);
        return result;
    }
}

