/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.portlet.reader;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.NewsDefinition;
import org.jasig.portlet.newsreader.UserDefinedNewsConfiguration;
import org.jasig.portlet.newsreader.UserDefinedNewsDefinition;
import org.jasig.portlet.newsreader.adapter.RomeAdapter;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.jasig.portlet.newsreader.mvc.NewsListingCommand;
import org.jasig.portlet.newsreader.service.NewsSetResolvingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;

@Controller
@RequestMapping(value={"EDIT"})
public class EditUserRomeController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private NewsStore newsStore;
    private NewsSetResolvingService setCreationService;

    @Autowired(required=true)
    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }

    @Autowired(required=true)
    public void setSetCreationService(NewsSetResolvingService setCreationService) {
        this.setCreationService = setCreationService;
    }

    @ModelAttribute(value="newsListingCommand")
    public NewsListingCommand getNewsForm(PortletRequest request) throws Exception {
        String id = request.getParameter("id");
        if (id != null && !id.equals("")) {
            Long configurationId = Long.parseLong(id);
            if (configurationId > -1L) {
                NewsConfiguration listing = this.newsStore.getNewsConfiguration(configurationId);
                this.log.debug((Object)("retrieved " + listing.toString()));
                NewsListingCommand command = new NewsListingCommand();
                command.setId(listing.getId());
                command.setName(listing.getNewsDefinition().getName());
                command.setUrl((String)listing.getNewsDefinition().getParameters().get("url"));
                command.setDisplayed(listing.isDisplayed());
                return command;
            }
            return new NewsListingCommand();
        }
        return new NewsListingCommand();
    }

    @RequestMapping(params={"action=editUrl"})
    public String getUserEditView(PortletRequest request) {
        return "editNewsUrl";
    }

    @ActionMapping(params={"action=editUrl"})
    public void onSubmitAction(ActionRequest request, ActionResponse response, NewsListingCommand form) throws Exception {
        UserDefinedNewsConfiguration config = null;
        UserDefinedNewsDefinition definition = null;
        if (form.getId() > -1L) {
            config = (UserDefinedNewsConfiguration)this.newsStore.getNewsConfiguration(form.getId());
            definition = (UserDefinedNewsDefinition)config.getNewsDefinition();
            definition.addParameter("url", form.getUrl());
            definition.setName(form.getName());
            this.log.debug((Object)"Updating");
        } else {
            definition = new UserDefinedNewsDefinition();
            definition.setClassName(RomeAdapter.class.getName());
            definition.addParameter("url", form.getUrl());
            definition.setName(form.getName());
            this.newsStore.storeNewsDefinition((NewsDefinition)definition);
            config = new UserDefinedNewsConfiguration();
            config.setNewsDefinition((NewsDefinition)definition);
            config.setDisplayed(form.isDisplayed());
            String setName = request.getPreferences().getValue("newsSetName", "default");
            config.setNewsSet(this.setCreationService.getNewsSet(setName, (PortletRequest)request));
            this.log.debug((Object)"Insert new");
        }
        this.log.debug((Object)("User defined News definition is " + config.getNewsDefinition().getName()));
        this.newsStore.storeNewsConfiguration((NewsConfiguration)config);
        response.setRenderParameter("action", "editPreferences");
    }
}

