/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.portlet.reader;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.NewsDefinition;
import org.jasig.portlet.newsreader.NewsSet;
import org.jasig.portlet.newsreader.PredefinedNewsConfiguration;
import org.jasig.portlet.newsreader.PredefinedNewsDefinition;
import org.jasig.portlet.newsreader.UserDefinedNewsConfiguration;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.jasig.portlet.newsreader.service.IViewResolver;
import org.jasig.portlet.newsreader.service.NewsSetResolvingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"EDIT"})
public class EditNewsPreferencesController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Map<String, String> predefinedEditActions;
    private NewsStore newsStore;
    private NewsSetResolvingService setCreationService;
    private IViewResolver viewResolver;

    @Resource(name="predefinedEditActions")
    public void setPredefinedEditActions(Map<String, String> predefinedEditActions) {
        this.predefinedEditActions = predefinedEditActions;
    }

    @Autowired(required=true)
    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }

    @Autowired(required=true)
    public void setSetCreationService(NewsSetResolvingService setCreationService) {
        this.setCreationService = setCreationService;
    }

    @Autowired(required=true)
    public void setViewResolver(IViewResolver viewResolver) {
        this.viewResolver = viewResolver;
    }

    @RequestMapping
    public ModelAndView showPreferencesView(RenderRequest request, RenderResponse response) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        PortletSession session = request.getPortletSession();
        String setName = request.getPreferences().getValue("newsSetName", "default");
        NewsSet set = this.setCreationService.getNewsSet(setName, (PortletRequest)request);
        Set configurations = set.getNewsConfigurations();
        ArrayList<UserDefinedNewsConfiguration> myNewsConfigurations = new ArrayList<UserDefinedNewsConfiguration>();
        ArrayList<PredefinedNewsConfiguration> predefinedNewsConfigurations = new ArrayList<PredefinedNewsConfiguration>();
        for (NewsConfiguration configuration : configurations) {
            if (configuration instanceof UserDefinedNewsConfiguration) {
                myNewsConfigurations.add((UserDefinedNewsConfiguration)configuration);
                continue;
            }
            if (!(configuration instanceof PredefinedNewsConfiguration)) continue;
            predefinedNewsConfigurations.add((PredefinedNewsConfiguration)configuration);
        }
        Collections.sort(myNewsConfigurations);
        Collections.sort(predefinedNewsConfigurations);
        model.put("myNewsConfigurations", myNewsConfigurations);
        model.put("predefinedNewsConfigurations", predefinedNewsConfigurations);
        Set userRoles = (Set)session.getAttribute("userRoles", 2);
        List definitions = this.newsStore.getHiddenPredefinedNewsDefinitions(set.getId(), userRoles);
        model.put("hiddenFeeds", definitions);
        model.put("predefinedEditActions", this.predefinedEditActions);
        String viewName = this.viewResolver.getPreferencesView((PortletRequest)request);
        return new ModelAndView(viewName, "model", model);
    }

    @ActionMapping
    protected void saveNewsPreference(ActionRequest request, ActionResponse response) throws Exception {
        Long id = Long.parseLong(request.getParameter("id"));
        String actionCode = request.getParameter("actionCode");
        PortletSession session = request.getPortletSession();
        Long setId = (Long)session.getAttribute("setId", 2);
        NewsSet set = this.newsStore.getNewsSet(setId);
        if (actionCode.equals("delete")) {
            NewsConfiguration config = this.newsStore.getNewsConfiguration(id);
            this.newsStore.deleteNewsConfiguration(config);
        } else if (actionCode.equals("show")) {
            NewsConfiguration config = this.newsStore.getNewsConfiguration(id);
            config.setDisplayed(true);
            this.newsStore.storeNewsConfiguration(config);
        } else if (actionCode.equals("hide")) {
            NewsConfiguration config = this.newsStore.getNewsConfiguration(id);
            config.setDisplayed(false);
            this.newsStore.storeNewsConfiguration(config);
        } else if (actionCode.equals("showNew")) {
            PredefinedNewsDefinition definition = (PredefinedNewsDefinition)this.newsStore.getNewsDefinition(id);
            this.log.debug((Object)("definition to save " + definition.toString()));
            PredefinedNewsConfiguration config = new PredefinedNewsConfiguration();
            config.setNewsDefinition((NewsDefinition)definition);
            config.setNewsSet(set);
            this.newsStore.storeNewsConfiguration((NewsConfiguration)config);
        }
    }

    @ResourceMapping
    public ModelAndView saveDisplayPreference(ResourceRequest request, ResourceResponse response) throws IOException {
        Map<String, String> model;
        try {
            String prefName = request.getParameter("prefName");
            String prefValue = request.getParameter("prefValue");
            PortletPreferences prefs = request.getPreferences();
            prefs.setValue(prefName, prefValue);
            prefs.store();
            model = Collections.singletonMap("status", "success");
        }
        catch (Exception e) {
            this.log.error((Object)"There was an error saving the preferences.", (Throwable)e);
            model = Collections.singletonMap("status", "failure");
        }
        return new ModelAndView("json", model);
    }
}

