/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.newsreader.mvc.portlet.reader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portlet.newsreader.NewsConfiguration;
import org.jasig.portlet.newsreader.NewsSet;
import org.jasig.portlet.newsreader.adapter.INewsAdapter;
import org.jasig.portlet.newsreader.adapter.NewsException;
import org.jasig.portlet.newsreader.dao.NewsStore;
import org.jasig.portlet.newsreader.model.NewsFeed;
import org.jasig.portlet.newsreader.service.NewsSetResolvingService;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class AjaxNewsController {
    protected final Log log = LogFactory.getLog(this.getClass());
    private NewsStore newsStore;
    private NewsSetResolvingService setCreationService;
    private ApplicationContext applicationContext;

    @Autowired(required=true)
    public void setNewsStore(NewsStore newsStore) {
        this.newsStore = newsStore;
    }

    @Autowired(required=true)
    public void setSetCreationService(NewsSetResolvingService setCreationService) {
        this.setCreationService = setCreationService;
    }

    @Autowired(required=true)
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @ResourceMapping
    public ModelAndView getJSONFeeds(ResourceRequest request, ResourceResponse response) throws Exception {
        HashMap<String, Object> model;
        block14: {
            this.log.debug((Object)"handleAjaxRequestInternal (AjaxNewsController)");
            model = new HashMap<String, Object>();
            String setName = request.getPreferences().getValue("newsSetName", "default");
            NewsSet set = this.setCreationService.getNewsSet(setName, (PortletRequest)request);
            ArrayList feeds = new ArrayList();
            feeds.addAll(set.getNewsConfigurations());
            Collections.sort(feeds);
            JSONArray jsonFeeds = new JSONArray();
            ArrayList<String> knownFeeds = new ArrayList<String>();
            for (NewsConfiguration feed : feeds) {
                if (!feed.isDisplayed()) continue;
                JSONObject jsonFeed = new JSONObject();
                jsonFeed.put((Object)"id", (Object)feed.getId());
                jsonFeed.put((Object)"name", (Object)feed.getNewsDefinition().getName());
                jsonFeeds.add((Object)jsonFeed);
                knownFeeds.add(String.valueOf(feed.getId()));
            }
            model.put("feeds", jsonFeeds);
            PortletPreferences prefs = request.getPreferences();
            String activeateNews = request.getParameter("activeateNews");
            if (activeateNews != null) {
                prefs.setValue("activeFeed", activeateNews);
                prefs.store();
            }
            int maxStories = Integer.parseInt(prefs.getValue("maxStories", "10"));
            boolean showAuthor = Boolean.parseBoolean(prefs.getValue("showAuthor", "true"));
            String activeFeed = request.getPreferences().getValue("activeFeed", null);
            if (!knownFeeds.contains(activeFeed)) {
                activeFeed = null;
            }
            if (activeFeed == null && jsonFeeds.size() > 0) {
                activeFeed = ((JSONObject)jsonFeeds.get(0)).getString("id");
                prefs.setValue("activeFeed", activeateNews);
                prefs.store();
            }
            if (activeFeed != null) {
                NewsConfiguration feedConfig = this.newsStore.getNewsConfiguration(Long.valueOf(activeFeed));
                model.put("activeFeed", feedConfig.getId());
                this.log.debug((Object)("On render Active feed is " + feedConfig.getId()));
                try {
                    INewsAdapter adapter = (INewsAdapter)this.applicationContext.getBean(feedConfig.getNewsDefinition().getClassName());
                    NewsFeed sharedFeed = adapter.getSyndFeed(feedConfig, (PortletRequest)request);
                    if (sharedFeed != null) {
                        if (sharedFeed.getEntries().size() > maxStories) {
                            NewsFeed limitedFeed = new NewsFeed();
                            limitedFeed.setAuthor(sharedFeed.getAuthor());
                            limitedFeed.setCopyright(sharedFeed.getCopyright());
                            limitedFeed.setLink(sharedFeed.getLink());
                            limitedFeed.setTitle(sharedFeed.getTitle());
                            limitedFeed.setEntries(sharedFeed.getEntries().subList(0, maxStories - 1));
                            model.put("feed", limitedFeed);
                        } else {
                            model.put("feed", sharedFeed);
                        }
                        break block14;
                    }
                    this.log.warn((Object)"Failed to get feed from adapter.");
                    model.put("message", "The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable.");
                }
                catch (NoSuchBeanDefinitionException ex) {
                    this.log.error((Object)("News class instance could not be found: " + ex.getMessage()));
                    model.put("message", "The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable.");
                }
                catch (NewsException ex) {
                    this.log.warn((Object)ex);
                    model.put("message", "The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable.");
                }
                catch (Exception ex) {
                    this.log.error((Object)ex);
                    model.put("message", "The news \"" + feedConfig.getNewsDefinition().getName() + "\" is currently unavailable.");
                }
            } else {
                model.put("message", "Select the news you wish to read.");
            }
        }
        this.log.debug((Object)"forwarding to /ajaxFeedList");
        String etag = String.valueOf(((Object)model).hashCode());
        if (request.getETag() != null && etag.equals(request.getETag())) {
            response.getCacheControl().setExpirationTime(300);
            response.getCacheControl().setUseCachedContent(true);
            return null;
        }
        response.getCacheControl().setETag(etag);
        response.getCacheControl().setExpirationTime(300);
        return new ModelAndView("json", model);
    }
}

