/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portlet.test.mvc.tests;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.ReadOnlyException;
import javax.portlet.RenderRequest;
import javax.portlet.ValidatorException;
import org.jasig.portlet.test.mvc.tests.BasePortletTest;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller(value="preferencesTest")
@RequestMapping(value={"VIEW", "EDIT", "HELP", "ABOUT"}, params={"currentTest=preferencesTest"})
public class PortletPrefrencesTest
extends BasePortletTest {
    private static final String NULL_PREFERENCES = "NULL_PREFERENCES";
    private static final String MIXED_PREFERENCES = "MIXED_PREFERENCES";
    private static final String NULL_PREFERENCE = "NULL_PREFERENCE";
    private static final String EMPTY_PREFERENCE = "EMPTY_PREFERENCE";

    public String getTestName() {
        return "Preferences Test";
    }

    @ActionMapping
    public void noopAction() {
    }

    @ActionMapping(value="setEmptyAndNull")
    public void setEmptyAndNullPrefernces(PortletRequest request) throws ReadOnlyException, ValidatorException, IOException {
        PortletPreferences preferences = request.getPreferences();
        preferences.setValue(EMPTY_PREFERENCE, "");
        preferences.setValue(NULL_PREFERENCE, null);
        preferences.setValues(MIXED_PREFERENCES, new String[]{null, "", null, "", null});
        preferences.setValues(NULL_PREFERENCES, null);
        preferences.store();
    }

    @RenderMapping
    protected ModelAndView handleRenderRequestInternal(RenderRequest request) throws Exception {
        PortletPreferences preferences = request.getPreferences();
        HashMap model = new HashMap();
        this.testPreference(preferences, model, EMPTY_PREFERENCE, "", new String[]{""});
        this.testPreference(preferences, model, NULL_PREFERENCE, null, new String[]{null});
        this.testPreference(preferences, model, MIXED_PREFERENCES, "", new String[]{null, "", null, "", null});
        this.testPreference(preferences, model, NULL_PREFERENCES, null, null);
        return new ModelAndView("preferencesTest", model);
    }

    protected void testPreference(PortletPreferences preferences, Map<String, Object> model, String pref, String expectedValue, String[] expectedValues) {
        String value = preferences.getValue(pref, "DEFAULT");
        Object[] values = preferences.getValues(pref, new String[]{"DEFAULT"});
        model.put(pref + "_value", expectedValue == value || expectedValue != null && expectedValue.equals(value));
        model.put(pref + "_values", Arrays.equals(expectedValues, values));
    }
}

