/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.auth;

import java.security.Provider;
import java.security.Security;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import net.spy.memcached.auth.PlainCallbackHandler;

public class AuthDescriptor {
    private final String[] mechs;
    private final CallbackHandler cbh;
    private final Map<String, ?> props;
    private final String serverName;
    private final Provider[] providers;
    private int authAttempts;
    private int allowedAuthAttempts;

    public AuthDescriptor(String[] m, CallbackHandler h, String s, Map<String, ?> p, Provider[] sp) {
        this.mechs = m;
        this.cbh = h;
        this.props = p;
        this.serverName = s;
        this.providers = sp;
        this.authAttempts = 0;
        String authThreshhold = System.getProperty("net.spy.memcached.auth.AuthThreshold");
        this.allowedAuthAttempts = authThreshhold != null ? Integer.parseInt(authThreshhold) : -1;
    }

    public AuthDescriptor(String[] m, CallbackHandler h, String s, Map<String, ?> p) {
        this(m, h, s, p, Security.getProviders());
    }

    public AuthDescriptor(String[] m, CallbackHandler h) {
        this(m, h, null, null, Security.getProviders());
    }

    public static AuthDescriptor typical(String u, String p) {
        return new AuthDescriptor(new String[]{"CRAM-MD5", "PLAIN"}, new PlainCallbackHandler(u, p));
    }

    public boolean authThresholdReached() {
        if (this.allowedAuthAttempts < 0) {
            return false;
        }
        if (this.authAttempts >= this.allowedAuthAttempts) {
            return true;
        }
        ++this.authAttempts;
        return false;
    }

    public String[] getMechs() {
        return this.mechs;
    }

    public CallbackHandler getCallback() {
        return this.cbh;
    }

    public Map<String, ?> getProperties() {
        return this.props;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Provider[] getProviders() {
        return this.providers;
    }
}

