/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.DataSourceConfiguration;
import org.infinispan.server.configuration.DataSourceConfigurationBuilder;
import org.infinispan.server.configuration.DataSourcesConfiguration;

public class DataSourcesConfigurationBuilder
implements Builder<DataSourcesConfiguration> {
    private final AttributeSet attributes;
    private final Map<String, DataSourceConfigurationBuilder> dataSources = new LinkedHashMap<String, DataSourceConfigurationBuilder>(2);
    private final Set<String> jndiNames = new HashSet<String>(2);

    DataSourcesConfigurationBuilder() {
        this.attributes = DataSourcesConfiguration.attributeDefinitionSet();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    DataSourceConfigurationBuilder dataSource(String name, String jndiName) {
        if (this.dataSources.containsKey(name)) {
            throw Server.log.duplicateDataSource(name);
        }
        if (this.jndiNames.contains(jndiName)) {
            throw Server.log.duplicateJndiName(jndiName);
        }
        DataSourceConfigurationBuilder builder = new DataSourceConfigurationBuilder(name, jndiName);
        this.dataSources.put(name, builder);
        this.jndiNames.add(jndiName);
        return builder;
    }

    public DataSourcesConfiguration create() {
        List<DataSourceConfiguration> list = this.dataSources.values().stream().map(DataSourceConfigurationBuilder::create).collect(Collectors.toList());
        return new DataSourcesConfiguration(this.attributes.protect(), list);
    }

    public DataSourcesConfigurationBuilder read(DataSourcesConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        this.dataSources.clear();
        return this;
    }
}

