/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp;

import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.infinispan.commons.CacheException;
import org.infinispan.server.resp.ByteBufPool;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.serialization.Resp3Response;

public final class RespErrorUtil {
    private RespErrorUtil() {
    }

    public static void unauthorized(ByteBufPool allocator) {
        RespErrorUtil.simpleErrorResponse("-WRONGPASS invalid username-password pair or user is disabled.", allocator);
    }

    public static void noSuchKey(ByteBufPool allocatorToUse) {
        RespErrorUtil.simpleErrorResponse("-ERR no such key", allocatorToUse);
    }

    public static void indexOutOfRange(ByteBufPool allocatorToUse) {
        RespErrorUtil.simpleErrorResponse("-ERR index out of range", allocatorToUse);
    }

    public static void wrongType(ByteBufPool allocatorToUse) {
        RespErrorUtil.simpleErrorResponse("-WRONGTYPE Operation against a key holding the wrong kind of value", allocatorToUse);
    }

    public static void wrongArgumentNumber(RespCommand command, ByteBufPool allocatorToUse) {
        RespErrorUtil.simpleErrorResponse("-ERR wrong number of arguments for '" + command.getName().toLowerCase() + "' command", allocatorToUse);
    }

    public static void unknownCommand(ByteBufPool allocator) {
        RespErrorUtil.simpleErrorResponse("-ERR unknown command", allocator);
    }

    public static void mustBePositive(ByteBufPool allocator) {
        RespErrorUtil.simpleErrorResponse("-ERR value is out of range, must be positive", allocator);
    }

    public static void mustBePositive(ByteBufPool allocator, String argumentName) {
        RespErrorUtil.simpleErrorResponse("-ERR value for ' " + argumentName + "' is out of range, must be positive", allocator);
    }

    public static void syntaxError(ByteBufPool allocator) {
        RespErrorUtil.simpleErrorResponse("-ERR syntax error", allocator);
    }

    public static void wrongArgumentCount(RespCommand command, ByteBufPool allocator) {
        RespErrorUtil.simpleErrorResponse("ERR wrong number of arguments for '" + command.getName().toLowerCase() + "' command", allocator);
    }

    public static void valueNotInteger(ByteBufPool allocator) {
        RespErrorUtil.simpleErrorResponse("-ERR value is not an integer or out of range", allocator);
    }

    public static void valueNotAValidFloat(ByteBufPool allocator) {
        RespErrorUtil.simpleErrorResponse("-ERR value is not a valid float", allocator);
    }

    public static void minOrMaxNotAValidFloat(ByteBufPool allocator) {
        RespErrorUtil.simpleErrorResponse("-ERR min or max is not a float", allocator);
    }

    public static void nanOrInfinity(ByteBufPool allocator) {
        RespErrorUtil.simpleErrorResponse("-ERR increment would produce NaN or Infinity", allocator);
    }

    public static void minOrMaxNotAValidStringRange(ByteBufPool allocator) {
        RespErrorUtil.simpleErrorResponse("-ERR min or max not valid string range item", allocator);
    }

    public static void transactionAborted(ByteBufPool allocatorToUse) {
        RespErrorUtil.simpleErrorResponse("-EXECABORT Transaction discarded because of previous errors.", allocatorToUse);
    }

    public static void customError(String message, ByteBufPool allocatorToUse) {
        RespErrorUtil.simpleErrorResponse("-ERR " + message, allocatorToUse);
    }

    public static void customRawError(String message, ByteBufPool alloc) {
        RespErrorUtil.simpleErrorResponse(message, alloc);
    }

    public static Consumer<ByteBufPool> handleException(Throwable t) {
        Throwable ex = t;
        while (ex instanceof CompletionException || ex instanceof CacheException) {
            ex = ex.getCause();
        }
        if (ex instanceof ClassCastException) {
            return RespErrorUtil::wrongType;
        }
        if (ex instanceof IllegalArgumentException && ex.getMessage().contains("No marshaller registered for object of Java type")) {
            return RespErrorUtil::wrongType;
        }
        if (ex instanceof IndexOutOfBoundsException) {
            return RespErrorUtil::indexOutOfRange;
        }
        if (ex instanceof NumberFormatException) {
            return RespErrorUtil::valueNotInteger;
        }
        return null;
    }

    public static boolean isWrongTypeError(Throwable t) {
        while (t instanceof CompletionException || t instanceof CacheException || t instanceof ExecutionException) {
            t = t.getCause();
        }
        return t instanceof ClassCastException || t instanceof IllegalArgumentException && t.getMessage().contains("No marshaller registered for object of Java type");
    }

    private static void simpleErrorResponse(CharSequence string, ByteBufPool alloc) {
        Resp3Response.error(string, alloc);
    }
}

