/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.dataconversion;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.configuration.ClassAllowList;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.OneToManyTranscoder;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.server.core.dataconversion.deserializer.Deserializer;
import org.infinispan.server.core.dataconversion.deserializer.SEntity;
import org.infinispan.server.core.dataconversion.json.SecureTypeResolverBuilder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JsonTranscoder
extends OneToManyTranscoder {
    protected static final Log logger = (Log)LogFactory.getLog(JsonTranscoder.class, Log.class);
    public static final String TYPE_PROPERTY = "_type";
    private final ObjectMapper objectMapper;
    private static final JsonFactory JSON_FACTORY = new JsonFactory();

    public JsonTranscoder() {
        this(JsonTranscoder.class.getClassLoader(), new ClassAllowList(Collections.emptyList()));
    }

    public JsonTranscoder(ClassAllowList allowList) {
        this(JsonTranscoder.class.getClassLoader(), allowList);
    }

    public JsonTranscoder(ClassLoader classLoader, ClassAllowList allowList) {
        super(MediaType.APPLICATION_JSON, new MediaType[]{MediaType.APPLICATION_OBJECT, MediaType.APPLICATION_OCTET_STREAM, MediaType.APPLICATION_SERIALIZED_OBJECT, MediaType.TEXT_PLAIN, MediaType.APPLICATION_WWW_FORM_URLENCODED, MediaType.APPLICATION_UNKNOWN});
        this.objectMapper = new ObjectMapper().setDefaultTyping((TypeResolverBuilder)new SecureTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL, allowList){
            {
                this.init(JsonTypeInfo.Id.CLASS, null);
                this.inclusion(JsonTypeInfo.As.PROPERTY);
                this.typeProperty(JsonTranscoder.TYPE_PROPERTY);
            }

            public boolean useForType(JavaType t) {
                return !t.isContainerType() && super.useForType(t);
            }
        });
        TypeFactory typeFactory = TypeFactory.defaultInstance().withClassLoader(classLoader);
        this.objectMapper.setTypeFactory(typeFactory);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Object doTranscode(Object content, MediaType contentType, MediaType destinationType) {
        if (destinationType.match(MediaType.APPLICATION_OCTET_STREAM) || destinationType.match(MediaType.APPLICATION_UNKNOWN)) {
            return StandardConversions.convertTextToOctetStream((Object)content, (MediaType)contentType);
        }
        boolean outputString = destinationType.hasStringType();
        Charset contentCharset = contentType.getCharset();
        Charset destinationCharset = destinationType.getCharset();
        if (destinationType.match(MediaType.APPLICATION_JSON)) {
            if (contentType.match(MediaType.APPLICATION_JSON)) {
                return this.convertCharset(content, contentCharset, destinationCharset, outputString);
            }
            try {
                if (contentType.match(MediaType.APPLICATION_SERIALIZED_OBJECT) && content instanceof byte[]) {
                    return this.convertJavaSerializedToJson((byte[])content, destinationCharset, outputString);
                }
                if (content instanceof String || content instanceof byte[]) {
                    return this.convertTextToJson(content, contentCharset, destinationCharset, outputString);
                }
                logger.jsonObjectConversionDeprecated();
                if (outputString) {
                    return this.objectMapper.writeValueAsString(content);
                }
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    byte[] byArray;
                    try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out, destinationCharset);){
                        this.objectMapper.writeValue((Writer)osw, content);
                        byArray = out.toByteArray();
                    }
                    return byArray;
                }
            }
            catch (IOException e) {
                throw logger.cannotConvertContent(content, contentType, destinationType, (Throwable)e);
            }
        }
        if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
            logger.jsonObjectConversionDeprecated();
            try {
                String destinationClassName = destinationType.getClassType();
                Class destinationClass = Object.class;
                if (destinationClassName != null) {
                    destinationClass = Class.forName(destinationClassName);
                }
                if (content instanceof byte[]) {
                    return this.objectMapper.readValue((byte[])content, destinationClass);
                }
                return this.objectMapper.readValue((String)content, destinationClass);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException((Throwable)e);
            }
        }
        if (destinationType.match(MediaType.TEXT_PLAIN)) {
            return this.convertCharset(content, contentCharset, destinationCharset, outputString);
        }
        throw logger.unsupportedContent(JsonTranscoder.class.getSimpleName(), content);
    }

    private Object convertJavaSerializedToJson(byte[] content, Charset destinationCharset, boolean outputAsString) {
        try {
            Deserializer deserializer = new Deserializer(new ByteArrayInputStream(content), true);
            SEntity entity = deserializer.readObject();
            String json = entity.json().toString();
            return outputAsString ? json : (Object)StandardConversions.convertCharset((Object)json, (Charset)StandardCharsets.UTF_8, (Charset)destinationCharset);
        }
        catch (IOException e) {
            throw logger.cannotConvertContent((Object)content, MediaType.APPLICATION_SERIALIZED_OBJECT, MediaType.APPLICATION_JSON, (Throwable)e);
        }
    }

    private Object convertTextToJson(Object content, Charset contentCharset, Charset destinationCharset, boolean asString) throws IOException {
        byte[] bytes;
        byte[] byArray = bytes = content instanceof byte[] ? (byte[])content : content.toString().getBytes(contentCharset);
        if (bytes.length == 0) {
            return bytes;
        }
        if (JsonTranscoder.isValidJson(bytes, contentCharset)) {
            return this.convertCharset(bytes, contentCharset, destinationCharset, asString);
        }
        throw logger.invalidJson(new String(bytes));
    }

    public static boolean isValidJson(byte[] content, Charset charset) {
        try (InputStreamReader isr = new InputStreamReader((InputStream)new ByteArrayInputStream(content), charset);
             BufferedReader reader = new BufferedReader(isr);
             JsonParser parser = JSON_FACTORY.createParser((Reader)reader);){
            parser.nextToken();
            while (parser.hasCurrentToken()) {
                parser.nextToken();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private Object convertCharset(Object content, Charset contentCharset, Charset destinationCharset, boolean outputAsString) {
        Object object;
        byte[] bytes = StandardConversions.convertCharset((Object)content, (Charset)contentCharset, (Charset)destinationCharset);
        if (outputAsString) {
            String string;
            object = string;
            string = new String(bytes, destinationCharset);
        } else {
            object = bytes;
        }
        return object;
    }
}

