/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexFieldReference;
import org.infinispan.protostream.MessageContext;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.query.remote.impl.indexing.aggregator.TypeAggregator;
import org.infinispan.query.remote.impl.mapping.reference.IndexReferenceHolder;

public final class IndexingMessageContext
extends MessageContext<IndexingMessageContext> {
    private final DocumentElement document;
    private final TypeAggregator typeAggregator;
    private Map<String, List<Float>> vectorAggregators;

    public IndexingMessageContext(IndexingMessageContext parentContext, FieldDescriptor fieldDescriptor, Descriptor messageDescriptor, DocumentElement document, TypeAggregator typeAggregator) {
        super((MessageContext)parentContext, fieldDescriptor, messageDescriptor);
        this.document = document;
        this.typeAggregator = typeAggregator;
    }

    public DocumentElement getDocument() {
        return this.document;
    }

    public TypeAggregator getTypeAggregator() {
        return this.typeAggregator;
    }

    public void addValue(IndexFieldReference fieldReference, Object value) {
        if (this.document != null) {
            this.document.addValue(fieldReference, value);
        }
    }

    public void addArrayItem(String fieldPath, Float value) {
        if (this.vectorAggregators == null) {
            this.vectorAggregators = new HashMap<String, List<Float>>();
        }
        this.vectorAggregators.putIfAbsent(fieldPath, new ArrayList(50));
        this.vectorAggregators.get(fieldPath).add(value);
    }

    public void writeVectorAggregators(IndexReferenceHolder indexReferenceHolder) {
        if (this.vectorAggregators == null) {
            return;
        }
        for (Map.Entry<String, List<Float>> entry : this.vectorAggregators.entrySet()) {
            IndexFieldReference<?> fieldReference = indexReferenceHolder.getFieldReference(entry.getKey());
            List<Float> values = entry.getValue();
            float[] value = new float[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                value[i] = values.get(i).floatValue();
            }
            this.addValue(fieldReference, value);
        }
    }
}

