/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.irac.IracTombstoneCleanupCommand;
import org.infinispan.commands.irac.IracTombstoneRemoteSiteCheckCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.versioning.irac.DefaultIracTombstoneManager;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.BlockingManager;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.irac.IracXSiteBackup;
import org.infinispan.xsite.status.SiteState;
import org.infinispan.xsite.status.TakeOfflineManager;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="xsite.irac.IracTombstoneUnitTest")
public class IracTombstoneUnitTest
extends AbstractInfinispanTest {
    private static Configuration createConfiguration(int targetSize, long maxCleanupDelay) {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        builder.sites().tombstoneMapSize(targetSize).maxTombstoneCleanupDelay(maxCleanupDelay).addBackup().site("A").strategy(BackupConfiguration.BackupStrategy.ASYNC);
        return builder.build();
    }

    private static Collection<IracXSiteBackup> backups() {
        return Collections.singleton(new IracXSiteBackup("A", true, 1000L, false, 0));
    }

    private static DistributionManager createDistributionManager() {
        DistributionManager dm = (DistributionManager)Mockito.mock(DistributionManager.class);
        DistributionInfo dInfo = (DistributionInfo)Mockito.mock(DistributionInfo.class);
        Mockito.when((Object)dInfo.isPrimary()).thenReturn((Object)true);
        Mockito.when((Object)dInfo.isWriteOwner()).thenReturn((Object)true);
        LocalizedCacheTopology cacheTopology = (LocalizedCacheTopology)Mockito.mock(LocalizedCacheTopology.class);
        Mockito.when((Object)cacheTopology.getSegmentDistribution(ArgumentMatchers.anyInt())).thenReturn((Object)dInfo);
        Mockito.when((Object)dm.getCacheTopology()).thenReturn((Object)cacheTopology);
        return dm;
    }

    private static TakeOfflineManager createTakeOfflineManager() {
        TakeOfflineManager tom = (TakeOfflineManager)Mockito.mock(TakeOfflineManager.class);
        Mockito.when((Object)tom.getSiteState(ArgumentMatchers.anyString())).thenReturn((Object)SiteState.OFFLINE);
        return tom;
    }

    private static CommandsFactory createCommandFactory() {
        CommandsFactory factory = (CommandsFactory)Mockito.mock(CommandsFactory.class);
        IracTombstoneRemoteSiteCheckCommand cmd = (IracTombstoneRemoteSiteCheckCommand)Mockito.mock(IracTombstoneRemoteSiteCheckCommand.class);
        Mockito.when((Object)factory.buildIracTombstoneRemoteSiteCheckCommand((List)ArgumentMatchers.any())).thenReturn((Object)cmd);
        IracTombstoneCleanupCommand cmd2 = (IracTombstoneCleanupCommand)Mockito.mock(IracTombstoneCleanupCommand.class);
        Mockito.when((Object)cmd2.isEmpty()).thenReturn((Object)false);
        Mockito.when((Object)factory.buildIracTombstoneCleanupCommand(ArgumentMatchers.anyInt())).thenReturn((Object)cmd2);
        return factory;
    }

    private static RpcManager createRpcManager() {
        RpcManager rpcManager = (RpcManager)Mockito.mock(RpcManager.class);
        RpcOptions rpcOptions = (RpcOptions)Mockito.mock(RpcOptions.class);
        Transport transport = (Transport)Mockito.mock(Transport.class);
        ((Transport)Mockito.doNothing().when((Object)transport)).checkCrossSiteAvailable();
        Mockito.when((Object)transport.localSiteName()).thenReturn((Object)"B");
        Mockito.when((Object)rpcManager.getTransport()).thenReturn((Object)transport);
        Mockito.when((Object)rpcManager.getSyncRpcOptions()).thenReturn((Object)rpcOptions);
        Mockito.when((Object)rpcManager.invokeCommand(ArgumentMatchers.anyCollection(), (ReplicableCommand)ArgumentMatchers.any(), (ResponseCollector)ArgumentMatchers.any(), (RpcOptions)ArgumentMatchers.any())).thenReturn((Object)CompletableFutures.completedNull());
        return rpcManager;
    }

    private static IracManager createIracManager(AtomicBoolean keep) {
        IracManager im = (IracManager)Mockito.mock(IracManager.class);
        Mockito.when((Object)im.containsKey(ArgumentMatchers.any())).thenAnswer(invocationOnMock -> keep.get());
        return im;
    }

    private static ScheduledExecutorService createScheduledExecutorService(Queue<? super RunnableData> queue) {
        ScheduledExecutorService executorService = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        Mockito.when(executorService.schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any()))).thenAnswer(invocationOnMock -> {
            queue.add(new RunnableData((Runnable)invocationOnMock.getArgument(0), (Long)invocationOnMock.getArgument(1)));
            return null;
        });
        return executorService;
    }

    private static IracMetadata createIracMetadata() {
        return (IracMetadata)Mockito.mock(IracMetadata.class);
    }

    private static BlockingManager createBlockingManager() {
        BlockingManager blockingManager = (BlockingManager)Mockito.mock(BlockingManager.class);
        Mockito.when((Object)blockingManager.asExecutor(ArgumentMatchers.anyString())).thenReturn((Object)new WithinThreadExecutor());
        Mockito.when((Object)blockingManager.thenComposeBlocking((CompletionStage)ArgumentMatchers.any(), (Function)ArgumentMatchers.any(), ArgumentMatchers.any())).thenAnswer(invocationOnMock -> {
            CompletionStage stage = (CompletionStage)invocationOnMock.getArgument(0);
            Function f = (Function)invocationOnMock.getArgument(1);
            return stage.thenCompose(f);
        });
        return blockingManager;
    }

    private static DefaultIracTombstoneManager createIracTombstoneManager(Queue<? super RunnableData> queue, int targetSize, long maxDelay, AtomicBoolean keep) {
        DefaultIracTombstoneManager manager = new DefaultIracTombstoneManager(IracTombstoneUnitTest.createConfiguration(targetSize, maxDelay), IracTombstoneUnitTest.backups());
        TestingUtil.inject(manager, IracTombstoneUnitTest.createDistributionManager(), IracTombstoneUnitTest.createTakeOfflineManager(), IracTombstoneUnitTest.createIracManager(keep), IracTombstoneUnitTest.createBlockingManager(), IracTombstoneUnitTest.createScheduledExecutorService(queue), IracTombstoneUnitTest.createCommandFactory(), IracTombstoneUnitTest.createRpcManager());
        return manager;
    }

    public void testDelayIncreaseWithNoTombstones() throws InterruptedException {
        LinkedBlockingDeque queue = new LinkedBlockingDeque();
        DefaultIracTombstoneManager manager = IracTombstoneUnitTest.createIracTombstoneManager(queue, 1, 1000L, new AtomicBoolean(false));
        manager.start();
        RunnableData data = (RunnableData)queue.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertNotNull((Object)data);
        AssertJUnit.assertEquals((long)500L, (long)data.delay);
        Iterator<Integer> iterator = Arrays.asList(707, 841, 917, 958, 979, 989, 994, 997, 998, 999, 999, 999).iterator();
        while (iterator.hasNext()) {
            long expectedDelay = iterator.next().intValue();
            data.runnable.run();
            data = (RunnableData)queue.poll(10L, TimeUnit.SECONDS);
            AssertJUnit.assertNotNull((Object)data);
            AssertJUnit.assertEquals((long)expectedDelay, (long)data.delay);
        }
        manager.stop();
    }

    public void testDelayAtSameRate() throws InterruptedException {
        int targetSize = 20;
        LinkedBlockingDeque queue = new LinkedBlockingDeque();
        DefaultIracTombstoneManager manager = IracTombstoneUnitTest.createIracTombstoneManager(queue, targetSize, 2000L, new AtomicBoolean(false));
        manager.start();
        RunnableData data = (RunnableData)queue.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertNotNull((Object)data);
        AssertJUnit.assertEquals((long)1000L, (long)data.delay);
        IracMetadata metadata = IracTombstoneUnitTest.createIracMetadata();
        IracTombstoneUnitTest.insertTombstones(targetSize, manager, metadata);
        data.runnable.run();
        data = (RunnableData)queue.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertNotNull((Object)data);
        AssertJUnit.assertEquals((long)1000L, (long)data.delay);
        manager.stop();
    }

    public void testDelayAtHigherRate() throws InterruptedException {
        int targetSize = 10;
        LinkedBlockingDeque queue = new LinkedBlockingDeque();
        DefaultIracTombstoneManager manager = IracTombstoneUnitTest.createIracTombstoneManager(queue, targetSize, 2000L, new AtomicBoolean(false));
        manager.start();
        RunnableData data = (RunnableData)queue.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertNotNull((Object)data);
        AssertJUnit.assertEquals((long)1000L, (long)data.delay);
        IracMetadata metadata = IracTombstoneUnitTest.createIracMetadata();
        IracTombstoneUnitTest.insertTombstones(targetSize * 2, manager, metadata);
        data.runnable.run();
        data = (RunnableData)queue.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertNotNull((Object)data);
        AssertJUnit.assertEquals((long)708L, (long)data.delay);
    }

    public void testDelayAtLowerRate() throws InterruptedException {
        int targetSize = 20;
        LinkedBlockingDeque queue = new LinkedBlockingDeque();
        DefaultIracTombstoneManager manager = IracTombstoneUnitTest.createIracTombstoneManager(queue, targetSize, 2000L, new AtomicBoolean(false));
        manager.start();
        RunnableData data = (RunnableData)queue.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertNotNull((Object)data);
        AssertJUnit.assertEquals((long)1000L, (long)data.delay);
        IracMetadata metadata = IracTombstoneUnitTest.createIracMetadata();
        IracTombstoneUnitTest.insertTombstones(targetSize / 2, manager, metadata);
        data.runnable.run();
        data = (RunnableData)queue.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertNotNull((Object)data);
        AssertJUnit.assertEquals((long)1414L, (long)data.delay);
        manager.stop();
    }

    public void testCleanupCantKeepUp() throws InterruptedException {
        int targetSize = 5;
        LinkedBlockingDeque queue = new LinkedBlockingDeque();
        AtomicBoolean keep = new AtomicBoolean(true);
        DefaultIracTombstoneManager manager = IracTombstoneUnitTest.createIracTombstoneManager(queue, targetSize, 1000L, keep);
        manager.start();
        RunnableData data = (RunnableData)queue.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertNotNull((Object)data);
        AssertJUnit.assertEquals((long)500L, (long)data.delay);
        IracMetadata metadata = IracTombstoneUnitTest.createIracMetadata();
        IracTombstoneUnitTest.insertTombstones(targetSize * 2, manager, metadata);
        data.runnable.run();
        data = (RunnableData)queue.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertNotNull((Object)data);
        AssertJUnit.assertEquals((long)1L, (long)data.delay);
        IracTombstoneUnitTest.insertTombstones(targetSize * 3, manager, metadata);
        data.runnable.run();
        data = (RunnableData)queue.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertNotNull((Object)data);
        AssertJUnit.assertEquals((long)1L, (long)data.delay);
        keep.set(false);
        data.runnable.run();
        data = (RunnableData)queue.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertNotNull((Object)data);
        AssertJUnit.assertEquals((long)32L, (long)data.delay);
        manager.stop();
    }

    private static void insertTombstones(int targetSize, DefaultIracTombstoneManager manager, IracMetadata metadata) {
        for (int i = 0; i < targetSize; ++i) {
            manager.storeTombstone(1, (Object)i, metadata);
        }
    }

    private static final class RunnableData {
        final Runnable runnable;
        final long delay;

        private RunnableData(Runnable runnable, long delay) {
            this.runnable = runnable;
            this.delay = delay;
        }
    }
}

