/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.irac;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.versioning.InequalVersionComparisonResult;
import org.infinispan.container.versioning.irac.DefaultIracVersionGenerator;
import org.infinispan.container.versioning.irac.IracEntryVersion;
import org.infinispan.container.versioning.irac.IracVersionGenerator;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.AbstractMultipleSitesTest;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.irac.IracRestartWithGlobalStateTest")
public class IracRestartWithGlobalStateTest
extends AbstractMultipleSitesTest {
    private static final int NUM_KEYS = 100;
    private final boolean persistent;

    public IracRestartWithGlobalStateTest(boolean persistent) {
        this.persistent = persistent;
    }

    @Factory
    public static Object[] defaultFactory() {
        return new Object[]{new IracRestartWithGlobalStateTest(false), new IracRestartWithGlobalStateTest(true)};
    }

    private static void forEachKeyValue(Method method, String prefix, BiConsumer<String, String> keyValueConsumer) {
        for (int i = 0; i < 100; ++i) {
            keyValueConsumer.accept(TestingUtil.k(method, i), TestingUtil.v(method, prefix, i));
        }
    }

    @Override
    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() {
        Util.recursiveFileRemove((String)CommonsTestingUtil.tmpDirectory(this.getClass()));
        super.createBeforeClass();
    }

    public void testRestart(Method method) {
        this.doTest(method, false);
    }

    public void testRestartReverse(Method method) {
        this.doTest(method, true);
    }

    @Override
    protected String[] parameterNames() {
        return new String[]{null};
    }

    @Override
    protected Object[] parameterValues() {
        return new String[]{this.persistent ? "PERSISTENT" : "VOLATILE"};
    }

    @Override
    protected int defaultNumberOfNodes() {
        return 3;
    }

    @Override
    protected ConfigurationBuilder defaultConfigurationForSite(int siteIndex) {
        ConfigurationBuilder builder = super.defaultConfigurationForSite(siteIndex);
        if (siteIndex == 0) {
            builder.sites().addBackup().site(this.siteName(1)).strategy(BackupConfiguration.BackupStrategy.ASYNC);
            if (this.persistent) {
                builder.persistence().addSoftIndexFileStore();
            }
        } else {
            builder.sites().addBackup().site(this.siteName(0)).strategy(BackupConfiguration.BackupStrategy.ASYNC);
        }
        return builder;
    }

    @Override
    protected void decorateGlobalConfiguration(GlobalConfigurationBuilder builder, int siteIndex, int nodeIndex) {
        String stateDirectory = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), "site_" + siteIndex, "node_" + nodeIndex});
        builder.globalState().enable().persistentLocation(stateDirectory);
    }

    private void doTest(Method method, boolean reverse) {
        IracRestartWithGlobalStateTest.forEachKeyValue(method, "initial", (k, v) -> this.cache(0, 0).put(k, v));
        IracRestartWithGlobalStateTest.forEachKeyValue(method, "initial", this::eventuallyAssertData);
        Map<Integer, IracEntryVersion> versionsBefore = this.snapshotPrimaryVersions();
        Map<String, IracEntryVersion> entryVersionsBefore = this.snapshotKeyVersions(method, 0);
        IracRestartWithGlobalStateTest.assertVersions(entryVersionsBefore, this.snapshotKeyVersions(method, 1), InequalVersionComparisonResult.EQUAL);
        log.debug((Object)"Stopping site_0");
        this.stopSite(0);
        log.debug((Object)"Starting site_0");
        this.restartSite(0);
        Map<Integer, IracEntryVersion> versionsAfter = this.snapshotPrimaryVersions();
        IracRestartWithGlobalStateTest.assertVersions(versionsBefore, versionsAfter, InequalVersionComparisonResult.EQUAL);
        IracRestartWithGlobalStateTest.forEachKeyValue(method, "final", (k, v) -> this.cache(reverse ? 1 : 0, 0).put(k, v));
        IracRestartWithGlobalStateTest.forEachKeyValue(method, "final", this::eventuallyAssertData);
        IracRestartWithGlobalStateTest.assertVersions(entryVersionsBefore, this.snapshotKeyVersions(method, 0), InequalVersionComparisonResult.BEFORE);
        IracRestartWithGlobalStateTest.assertVersions(entryVersionsBefore, this.snapshotKeyVersions(method, 1), InequalVersionComparisonResult.BEFORE);
    }

    private Map<Integer, IracEntryVersion> snapshotPrimaryVersions() {
        HashMap<Integer, IracEntryVersion> versions = new HashMap<Integer, IracEntryVersion>(256);
        for (Cache cache : this.caches(0)) {
            DefaultIracVersionGenerator vGenerator = IracRestartWithGlobalStateTest.generator(cache);
            LocalizedCacheTopology topology = TestingUtil.extractCacheTopology(cache);
            Map cacheVersions = vGenerator.peek();
            log.tracef("Taking snapshot from %s (%s entries): %s", (Object)DistributionTestHelper.addressOf(cache), (Object)cacheVersions.size(), (Object)cacheVersions);
            cacheVersions.forEach((segment, version) -> {
                if (topology.getSegmentDistribution(segment.intValue()).isPrimary()) {
                    IracEntryVersion v = versions.putIfAbsent((Integer)segment, (IracEntryVersion)version);
                    AssertJUnit.assertNull((Object)v);
                }
            });
            log.tracef("Global versions after %s (%s entries): %s", (Object)DistributionTestHelper.addressOf(cache), (Object)versions.size(), versions);
        }
        return versions;
    }

    private Map<String, IracEntryVersion> snapshotKeyVersions(Method method, int siteIndex) {
        HashMap<String, IracEntryVersion> versions = new HashMap<String, IracEntryVersion>(256);
        for (Cache cache : this.caches(siteIndex)) {
            LocalizedCacheTopology topology = TestingUtil.extractCacheTopology(cache);
            InternalDataContainer dataContainer = TestingUtil.extractComponent(cache, InternalDataContainer.class);
            for (int i = 0; i < 100; ++i) {
                String key = TestingUtil.k(method, i);
                DistributionInfo distributionInfo = topology.getDistribution((Object)key);
                if (!distributionInfo.isPrimary()) continue;
                IracEntryVersion version = dataContainer.peek(distributionInfo.segmentId(), (Object)key).getInternalMetadata().iracMetadata().getVersion();
                AssertJUnit.assertNotNull((Object)version);
                versions.put(key, version);
            }
        }
        return versions;
    }

    private static DefaultIracVersionGenerator generator(Cache<?, ?> cache) {
        return (DefaultIracVersionGenerator)TestingUtil.extractComponent(cache, IracVersionGenerator.class);
    }

    private static <K> void assertVersions(Map<K, IracEntryVersion> v1, Map<K, IracEntryVersion> v2, InequalVersionComparisonResult expected) {
        AssertJUnit.assertEquals((int)v1.size(), (int)v2.size());
        Iterator iterator = Stream.concat(v1.keySet().stream(), v2.keySet().stream()).distinct().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            IracEntryVersion version1 = v1.get(key);
            IracEntryVersion version2 = v2.get(key);
            AssertJUnit.assertNotNull((String)String.format("'%s' version is null for Map 1", key), (Object)version1);
            AssertJUnit.assertNotNull((String)String.format("'%s' version is null for Map 2", key), (Object)version2);
            InequalVersionComparisonResult result = version1.compareTo(version2);
            AssertJUnit.assertEquals((String)String.format("'%s' version mismatch: %s and %s", key, version1, version2), (Object)expected, (Object)result);
        }
    }

    private void eventuallyAssertData(String key, String value) {
        this.eventuallyAssertInAllSitesAndCaches(cache -> Objects.equals(value, cache.get((Object)key)));
    }
}

