/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.Arrays;
import java.util.HashSet;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.TakeOfflineConfigurationBuilder;
import org.infinispan.configuration.cache.XSiteStateTransferMode;
import org.infinispan.manager.CacheContainer;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.test.TestingUtil;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.infinispan.xsite.XSiteAdminOperations;
import org.infinispan.xsite.status.DefaultTakeOfflineManager;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.XSiteAdminOperationsTest")
public class XSiteAdminOperationsTest
extends AbstractTwoSitesTest {
    public XSiteAdminOperationsTest() {
        this.lonBackupStrategy = BackupConfiguration.BackupStrategy.ASYNC;
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        return XSiteAdminOperationsTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return XSiteAdminOperationsTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
    }

    public void testSiteStatus() {
        AssertJUnit.assertEquals((String)this.admin("LON-1", 0).siteStatus("NYC-2"), (String)"online");
        AssertJUnit.assertEquals((String)this.admin("LON-1", 1).siteStatus("NYC-2"), (String)"online");
        AssertJUnit.assertEquals((String)"ok", (String)this.admin("LON-1", 1).takeSiteOffline("NYC-2"));
        AssertJUnit.assertEquals((String)this.admin("LON-1", 0).siteStatus("NYC-2"), (String)"offline");
        AssertJUnit.assertEquals((String)this.admin("LON-1", 1).siteStatus("NYC-2"), (String)"offline");
        AssertJUnit.assertEquals((String)"ok", (String)this.admin("LON-1", 1).bringSiteOnline("NYC-2"));
        AssertJUnit.assertEquals((String)this.admin("LON-1", 0).siteStatus("NYC-2"), (String)"online");
        AssertJUnit.assertEquals((String)this.admin("LON-1", 1).siteStatus("NYC-2"), (String)"online");
    }

    public void amendTakeOffline() {
        AssertJUnit.assertEquals((String)this.admin("LON-1", 0).siteStatus("NYC-2"), (String)"online");
        AssertJUnit.assertEquals((String)this.admin("LON-1", 1).siteStatus("NYC-2"), (String)"online");
        DefaultTakeOfflineManager tom = this.takeOfflineManager("LON-1", 0);
        AssertJUnit.assertEquals((Object)tom.getConfiguration("NYC-2"), (Object)new TakeOfflineConfigurationBuilder(null, null).afterFailures(0).minTimeToWait(0L).create());
        AssertJUnit.assertEquals((String)"ok", (String)this.admin("LON-1", 1).amendTakeOffline("NYC-2", 7, 12L));
        AssertJUnit.assertEquals((Object)tom.getConfiguration("NYC-2"), (Object)new TakeOfflineConfigurationBuilder(null, null).afterFailures(7).minTimeToWait(12L).create());
        AssertJUnit.assertEquals((String)"ok", (String)this.admin("LON-1", 1).setTakeOfflineAfterFailures("NYC-2", 8));
        AssertJUnit.assertEquals((Object)tom.getConfiguration("NYC-2"), (Object)new TakeOfflineConfigurationBuilder(null, null).afterFailures(8).minTimeToWait(12L).create());
        AssertJUnit.assertEquals((String)"ok", (String)this.admin("LON-1", 1).setTakeOfflineMinTimeToWait("NYC-2", 13L));
        AssertJUnit.assertEquals((Object)tom.getConfiguration("NYC-2"), (Object)new TakeOfflineConfigurationBuilder(null, null).afterFailures(8).minTimeToWait(13L).create());
        AssertJUnit.assertEquals((String)this.admin("LON-1", 0).getTakeOfflineAfterFailures("NYC-2"), (String)"8");
        AssertJUnit.assertEquals((String)this.admin("LON-1", 0).getTakeOfflineMinTimeToWait("NYC-2"), (String)"13");
        AssertJUnit.assertEquals((String)this.admin("LON-1", 1).getTakeOfflineAfterFailures("NYC-2"), (String)"8");
        AssertJUnit.assertEquals((String)this.admin("LON-1", 1).getTakeOfflineMinTimeToWait("NYC-2"), (String)"13");
    }

    public void testStatus() {
        AssertJUnit.assertEquals((String)this.admin("LON-1", 0).status(), (String)String.format("%s[ONLINE]", "NYC-2"));
        AssertJUnit.assertEquals((String)this.admin("LON-1", 1).status(), (String)String.format("%s[ONLINE]", "NYC-2"));
        AssertJUnit.assertEquals((String)"ok", (String)this.admin("LON-1", 1).takeSiteOffline("NYC-2"));
        AssertJUnit.assertEquals((String)this.admin("LON-1", 0).status(), (String)String.format("%s[OFFLINE]", "NYC-2"));
        AssertJUnit.assertEquals((String)this.admin("LON-1", 1).status(), (String)String.format("%s[OFFLINE]", "NYC-2"));
        AssertJUnit.assertEquals((String)"ok", (String)this.admin("LON-1", 1).bringSiteOnline("NYC-2"));
        AssertJUnit.assertEquals((String)this.admin("LON-1", 0).status(), (String)String.format("%s[ONLINE]", "NYC-2"));
        AssertJUnit.assertEquals((String)this.admin("LON-1", 1).status(), (String)String.format("%s[ONLINE]", "NYC-2"));
    }

    public void testStateTransferMode() {
        int i;
        for (i = 0; i < this.initialClusterSize; ++i) {
            AssertJUnit.assertEquals((String)XSiteStateTransferMode.MANUAL.toString(), (String)this.admin("LON-1", i).getStateTransferMode("NYC-2"));
            AssertJUnit.assertEquals((String)XSiteStateTransferMode.MANUAL.toString(), (String)this.admin("NYC-2", i).getStateTransferMode("LON-1"));
        }
        AssertJUnit.assertTrue((boolean)this.admin("LON-1", 0).setStateTransferMode("NYC-2", XSiteStateTransferMode.AUTO.toString()));
        for (i = 0; i < this.initialClusterSize; ++i) {
            AssertJUnit.assertEquals((String)XSiteStateTransferMode.AUTO.toString(), (String)this.admin("LON-1", i).getStateTransferMode("NYC-2"));
            AssertJUnit.assertEquals((String)XSiteStateTransferMode.MANUAL.toString(), (String)this.admin("NYC-2", i).getStateTransferMode("LON-1"));
        }
        Exceptions.expectException(CacheConfigurationException.class, (String)"ISPN000634.*", () -> this.admin("NYC-2", 0).setStateTransferMode("LON-1", XSiteStateTransferMode.AUTO.toString()));
        for (i = 0; i < this.initialClusterSize; ++i) {
            AssertJUnit.assertEquals((String)XSiteStateTransferMode.AUTO.toString(), (String)this.admin("LON-1", i).getStateTransferMode("NYC-2"));
            AssertJUnit.assertEquals((String)XSiteStateTransferMode.MANUAL.toString(), (String)this.admin("NYC-2", i).getStateTransferMode("LON-1"));
        }
        AssertJUnit.assertTrue((boolean)this.admin("LON-1", 0).setStateTransferMode("NYC-2", XSiteStateTransferMode.MANUAL.toString()));
        for (i = 0; i < this.initialClusterSize; ++i) {
            AssertJUnit.assertEquals((String)XSiteStateTransferMode.MANUAL.toString(), (String)this.admin("LON-1", i).getStateTransferMode("NYC-2"));
            AssertJUnit.assertEquals((String)XSiteStateTransferMode.MANUAL.toString(), (String)this.admin("NYC-2", i).getStateTransferMode("LON-1"));
        }
        AssertJUnit.assertFalse((boolean)this.admin("LON-1", 0).setStateTransferMode("NYC-2", XSiteStateTransferMode.MANUAL.toString()));
    }

    public void testSitesView() {
        AssertJUnit.assertEquals(new HashSet<String>(Arrays.asList("LON-1", "NYC-2")), (Object)TestingUtil.extractGlobalComponent((CacheContainer)this.site("LON-1").cacheManagers().get(0), Transport.class).getSitesView());
        AssertJUnit.assertEquals(new HashSet<String>(Arrays.asList("LON-1", "NYC-2")), (Object)TestingUtil.extractGlobalComponent((CacheContainer)this.site("LON-1").cacheManagers().get(0), Transport.class).getSitesView());
    }

    private XSiteAdminOperations admin(String site, int cache) {
        return TestingUtil.extractComponent(this.cache(site, cache), XSiteAdminOperations.class);
    }
}

