/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.container.versioning.irac.DefaultIracTombstoneManager;
import org.infinispan.container.versioning.irac.IracTombstoneManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.xsite.irac.DefaultIracManager;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.irac.ManualIracManager;
import org.infinispan.xsite.status.DefaultTakeOfflineManager;
import org.infinispan.xsite.status.TakeOfflineManager;
import org.jgroups.protocols.relay.RELAY2;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public abstract class AbstractXSiteTest
extends AbstractCacheTest {
    protected final List<TestSite> sites = new ArrayList<TestSite>();
    private final Map<String, Integer> siteName2index = new HashMap<String, Integer>();

    @BeforeMethod(alwaysRun=true)
    public void createBeforeMethod() {
        if (this.cleanupAfterMethod()) {
            this.createSites();
        }
    }

    @BeforeClass(alwaysRun=true)
    public void createBeforeClass() {
        if (this.cleanupAfterTest()) {
            this.createSites();
        }
    }

    @AfterMethod(alwaysRun=true)
    protected void clearContent() throws Throwable {
        if (this.cleanupAfterTest()) {
            this.clearSites();
        } else {
            this.killSites();
        }
    }

    private void clearSites() {
        for (TestSite ts : this.sites) {
            this.clearSite(ts);
        }
    }

    protected void clearSite(TestSite ts) {
        TestingUtil.clearContent(ts.cacheManagers);
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        if (this.cleanupAfterTest()) {
            this.killSites();
        }
    }

    protected void killSites() {
        for (TestSite ts : this.sites) {
            this.killSite(ts);
        }
        this.sites.clear();
        this.siteName2index.clear();
    }

    protected void killSite(String siteName) {
        Integer index = this.siteName2index.remove(siteName);
        if (index == null) {
            return;
        }
        TestSite site = this.sites.remove(index);
        this.killSite(site);
    }

    protected void killSite(TestSite ts) {
        ts.cacheManagers.forEach(Lifecycle::stop);
    }

    protected void stopSite(int siteIndex) {
        TestSite site = this.site(siteIndex);
        List<EmbeddedCacheManager> cacheManagers = site.cacheManagers;
        while (!cacheManagers.isEmpty()) {
            cacheManagers.remove(cacheManagers.size() - 1).stop();
            if (cacheManagers.isEmpty()) continue;
            site.waitForClusterToForm(null);
        }
        AssertJUnit.assertTrue((boolean)site.cacheManagers.isEmpty());
    }

    protected abstract void createSites();

    protected TestSite createSite(String siteName, int numNodes, GlobalConfigurationBuilder gcb, ConfigurationBuilder cb) {
        return this.createSite(siteName, numNodes, gcb, null, cb);
    }

    protected TestSite createSite(String siteName, int numNodes, GlobalConfigurationBuilder gcb, String cacheName, ConfigurationBuilder cb) {
        TestSite testSite = this.addSite(siteName);
        testSite.createClusteredCaches(numNodes, cacheName, gcb, cb);
        return testSite;
    }

    protected TestSite addSite(String siteName) {
        TestSite testSite = new TestSite(siteName, this.sites.size());
        this.sites.add(testSite);
        this.siteName2index.put(siteName, this.sites.size() - 1);
        return testSite;
    }

    public void waitForSites() {
        this.waitForSites(10L, TimeUnit.SECONDS, this.siteName2index.keySet().toArray(new String[0]));
    }

    public void waitForSites(String ... siteNames) {
        this.waitForSites(10L, TimeUnit.SECONDS, siteNames);
    }

    public void waitForSites(long timeout, TimeUnit unit, String ... siteNames) {
        long deadlineNanos = System.nanoTime() + unit.toNanos(timeout);
        HashSet<String> expectedSites = new HashSet<String>(Arrays.asList(siteNames));
        this.sites.forEach(site -> site.cacheManagers.forEach(manager -> {
            JGroupsTransport transport = (JGroupsTransport)TestingUtil.extractGlobalComponent((CacheContainer)manager, Transport.class);
            RELAY2 relay2 = (RELAY2)transport.getChannel().getProtocolStack().findProtocol(RELAY2.class);
            if (!relay2.isSiteMaster()) {
                return;
            }
            while (System.nanoTime() - deadlineNanos < 0L && !expectedSites.equals(transport.getSitesView())) {
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100L));
            }
            Set currentSitesView = transport.getSitesView();
            if (!expectedSites.equals(currentSitesView)) {
                throw new AssertionError((Object)String.format("Timed out waiting for bridge view %s on %s after %d %s. Current bridge view is %s", new Object[]{expectedSites, manager.getAddress(), timeout, unit, currentSitesView}));
            }
        }));
    }

    protected TestSite site(int index) {
        return this.sites.get(index);
    }

    protected EmbeddedCacheManager manager(int siteIndex, int managerIndex) {
        return this.sites.get(siteIndex).cacheManagers().get(managerIndex);
    }

    protected TestSite site(String name) {
        return this.sites.get(this.siteName2index.get(name));
    }

    protected <K, V> Cache<K, V> cache(String site, int index) {
        return this.site(site).cache(index);
    }

    protected <K, V> Cache<K, V> cache(String site, String cacheName, int index) {
        return this.site(site).cache(cacheName, index);
    }

    protected <K, V> Cache<K, V> cache(int siteIndex, String cacheName, int nodeIndex) {
        return this.site(siteIndex).cache(cacheName, nodeIndex);
    }

    protected <K, V> List<Cache<K, V>> caches(String site) {
        return this.caches(site, null);
    }

    protected <K, V> List<Cache<K, V>> caches(String site, String cacheName) {
        return Collections.unmodifiableList(this.site(site).getCaches(cacheName));
    }

    protected <K, V> List<Cache<K, V>> caches(int siteIndex) {
        return this.caches(siteIndex, null);
    }

    protected <K, V> List<Cache<K, V>> caches(int siteIndex, String cacheName) {
        return Collections.unmodifiableList(this.site(siteIndex).getCaches(cacheName));
    }

    protected <K, V> Cache<K, V> cache(int siteIndex, int cacheIndex) {
        return this.site(siteIndex).cache(cacheIndex);
    }

    protected <K, V> Cache<K, V> cache(int siteIndex, int cacheIndex, String cacheName) {
        return this.site(siteIndex).cache(cacheName, cacheIndex);
    }

    protected void startCache(String siteName, String cacheName, ConfigurationBuilder configurationBuilder) {
        TestSite site = this.site(siteName);
        for (EmbeddedCacheManager ecm : site.cacheManagers) {
            Configuration config = configurationBuilder.build();
            ecm.defineConfiguration(cacheName, this.getDefaultCacheName(), config);
        }
        site.waitForClusterToForm(cacheName);
    }

    protected final <K, V> void assertInSite(String siteName, AssertCondition<K, V> condition) {
        for (Cache<K, V> cache : this.caches(siteName)) {
            condition.assertInCache(cache);
        }
    }

    protected final <K, V> void assertInSite(String siteName, String cacheName, AssertCondition<K, V> condition) {
        for (Cache<K, V> cache : this.caches(siteName, cacheName)) {
            condition.assertInCache(cache);
        }
    }

    protected final <K, V> void assertEventuallyInSite(String siteName, EventuallyAssertCondition<K, V> condition, long timeout, TimeUnit timeUnit) {
        AbstractXSiteTest.eventually(() -> {
            for (Cache cache : this.caches(siteName)) {
                if (condition.assertInCache(cache)) continue;
                return false;
            }
            return true;
        }, timeUnit.toMillis(timeout));
    }

    protected final <K, V> void assertEventuallyInSite(String siteName, String cacheName, EventuallyAssertCondition<K, V> condition, long timeout, TimeUnit timeUnit) {
        AbstractXSiteTest.eventually(() -> {
            for (Cache cache : this.caches(siteName, cacheName)) {
                if (condition.assertInCache(cache)) continue;
                return false;
            }
            return true;
        }, timeUnit.toMillis(timeout));
    }

    protected void decorateGlobalConfiguration(GlobalConfigurationBuilder builder, int siteIndex, int nodeIndex) {
    }

    protected void decorateCacheConfiguration(ConfigurationBuilder builder, int siteIndex, int nodeIndex) {
    }

    protected TransactionTable txTable(Cache cache) {
        return (TransactionTable)ComponentRegistry.componentOf((Cache)cache, TransactionTable.class);
    }

    protected DefaultTakeOfflineManager takeOfflineManager(String site, String cacheName, int index) {
        return (DefaultTakeOfflineManager)ComponentRegistry.componentOf(this.cache(site, cacheName, index), TakeOfflineManager.class);
    }

    protected DefaultTakeOfflineManager takeOfflineManager(String site, int index) {
        return (DefaultTakeOfflineManager)ComponentRegistry.componentOf(this.cache(site, index), TakeOfflineManager.class);
    }

    protected DefaultIracManager iracManager(String site, String cacheName, int index) {
        return (DefaultIracManager)TestingUtil.extractComponent(this.cache(site, cacheName, index), IracManager.class);
    }

    protected boolean isIracManagerEmpty(Cache<?, ?> cache) {
        IracManager manager = TestingUtil.extractComponent(cache, IracManager.class);
        if (manager instanceof ManualIracManager) {
            return ((ManualIracManager)manager).isEmpty();
        }
        if (manager instanceof DefaultIracManager) {
            return ((DefaultIracManager)manager).isEmpty();
        }
        return true;
    }

    protected DefaultIracTombstoneManager iracTombstoneManager(Cache<?, ?> cache) {
        return (DefaultIracTombstoneManager)TestingUtil.extractComponent(cache, IracTombstoneManager.class);
    }

    @Override
    protected final String parameters() {
        return AbstractXSiteTest.defaultParametersString(this.parameterNames(), this.parameterValues());
    }

    protected String[] parameterNames() {
        return new String[0];
    }

    protected Object[] parameterValues() {
        return new Object[0];
    }

    public class TestSite {
        protected List<EmbeddedCacheManager> cacheManagers = new ArrayList<EmbeddedCacheManager>();
        private final String siteName;
        private final int siteIndex;

        public TestSite(String siteName, int siteIndex) {
            this.siteName = siteName;
            this.siteIndex = siteIndex;
        }

        public String getSiteName() {
            return this.siteName;
        }

        public int getSiteIndex() {
            return this.siteIndex;
        }

        public EmbeddedCacheManager addCacheManager(String cacheName, GlobalConfigurationBuilder globalTemplate, ConfigurationBuilder cacheTemplate, boolean waitForCluster) {
            int i = this.cacheManagers.size();
            TransportFlags flags = this.transportFlags();
            GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
            gcb.read(globalTemplate.build());
            AbstractXSiteTest.this.decorateGlobalConfiguration(gcb, this.siteIndex, i);
            ConfigurationBuilder builder = new ConfigurationBuilder();
            builder.read(cacheTemplate.build(), Combine.DEFAULT);
            AbstractXSiteTest.this.decorateCacheConfiguration(builder, this.siteIndex, i);
            ConfigurationBuilder defaultBuilder = cacheName == null ? builder : null;
            EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(flags, gcb, defaultBuilder);
            if (cacheName != null) {
                cm.defineConfiguration(cacheName, builder.build());
                cm.getCache(cacheName);
            }
            if (waitForCluster) {
                this.waitForClusterToForm(cacheName);
            }
            return cm;
        }

        private TransportFlags transportFlags() {
            return new TransportFlags().withSiteIndex(this.siteIndex).withSiteName(this.siteName).withFD(true);
        }

        protected <K, V> List<Cache<K, V>> createClusteredCaches(int numMembersInCluster, String cacheName, GlobalConfigurationBuilder globalTemplate, ConfigurationBuilder cacheTemplate) {
            return this.createClusteredCaches(numMembersInCluster, cacheName, globalTemplate, cacheTemplate, false);
        }

        protected <K, V> List<Cache<K, V>> createClusteredCaches(int numMembersInCluster, String cacheName, GlobalConfigurationBuilder globalTemplate, ConfigurationBuilder cacheTemplate, boolean waitBetweenCacheManager) {
            ArrayList<Cache<K, V>> caches = new ArrayList<Cache<K, V>>(numMembersInCluster);
            for (int i = 0; i < numMembersInCluster; ++i) {
                EmbeddedCacheManager cm = this.addCacheManager(cacheName, globalTemplate, cacheTemplate, waitBetweenCacheManager);
                if (cacheName != null) {
                    caches.add(cm.getCache(cacheName));
                    continue;
                }
                caches.add(cm.getCache());
            }
            this.waitForClusterToForm(cacheName);
            return caches;
        }

        protected EmbeddedCacheManager addClusterEnabledCacheManager(TransportFlags flags, GlobalConfigurationBuilder gcb, ConfigurationBuilder builder) {
            GlobalConfigurationBuilder clone = GlobalConfigurationBuilder.defaultClusteredBuilder();
            Transport transport = clone.transport().getTransport();
            GlobalConfiguration original = gcb.build();
            clone.read(original);
            clone.transport().transport(transport);
            clone.transport().clusterName("ISPN(SITE " + this.siteName + ")");
            if (original.jmx().enabled()) {
                clone.jmx().enabled(true).domain(original.jmx().domain() + this.cacheManagers.size());
            }
            EmbeddedCacheManager cm = TestCacheManagerFactory.createClusteredCacheManager(clone, builder, flags);
            this.cacheManagers.add(cm);
            return cm;
        }

        public void waitForClusterToForm(String cacheName) {
            List caches = this.getCaches(cacheName);
            Cache cache = caches.get(0);
            TestingUtil.blockUntilViewsReceived(10000, caches);
            if (cache.getCacheConfiguration().clustering().cacheMode().isDistributed()) {
                TestingUtil.waitForNoRebalance(caches);
            }
        }

        public void waitForClusterToForm(String cacheName, long timeout, TimeUnit timeUnit) {
            List caches = this.getCaches(cacheName);
            Cache cache = caches.get(0);
            TestingUtil.blockUntilViewsReceived((int)timeUnit.toMillis(timeout), false, caches);
            if (cache.getCacheConfiguration().clustering().cacheMode().isDistributed()) {
                TestingUtil.waitForNoRebalance(caches);
            }
        }

        public <K, V> List<Cache<K, V>> getCaches(String cacheName) {
            ArrayList<Cache<K, V>> caches = new ArrayList<Cache<K, V>>(this.cacheManagers.size());
            for (EmbeddedCacheManager cm : this.cacheManagers) {
                caches.add(cacheName == null ? cm.getCache() : cm.getCache(cacheName));
            }
            return caches;
        }

        public void addCache(GlobalConfigurationBuilder gBuilder, ConfigurationBuilder builder) {
            this.addCache(null, gBuilder, builder);
        }

        public void addCache(String cacheName, GlobalConfigurationBuilder gBuilder, ConfigurationBuilder builder) {
            EmbeddedCacheManager cm = this.addClusterEnabledCacheManager(this.transportFlags(), gBuilder, builder);
            if (cacheName != null) {
                cm.defineConfiguration(cacheName, builder.build());
            }
        }

        public void kill(int index) {
            TestingUtil.killCacheManagers(this.cacheManagers.remove(index));
        }

        public <K, V> Cache<K, V> cache(int index) {
            return this.cacheManagers.get(index).getCache();
        }

        public <K, V> AdvancedCache<K, V> advancedCache(int index) {
            Cache<K, V> cache = this.cache(index);
            return cache.getAdvancedCache();
        }

        public <K, V> Cache<K, V> cache(String cacheName, int index) {
            return cacheName == null ? this.cache(index) : this.cacheManagers.get(index).getCache(cacheName);
        }

        public List<EmbeddedCacheManager> cacheManagers() {
            return Collections.unmodifiableList(this.cacheManagers);
        }
    }

    protected static interface AssertCondition<K, V> {
        public void assertInCache(Cache<K, V> var1);
    }

    protected static interface EventuallyAssertCondition<K, V> {
        public boolean assertInCache(Cache<K, V> var1);
    }
}

