/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.util.Optional;
import java.util.UUID;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.util.logging.events.EventLog;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogLevel;
import org.infinispan.util.logging.events.EventLogSerializer;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="util.EventLogSerializerTest", groups={"unit"})
public class EventLogSerializerTest
extends AbstractInfinispanTest {
    private static final String JSON_TEMPLATE = "{\"log\":{\"category\":\"CLUSTER\",\"content\":{\"level\":\"INFO\",\"message\":\"%s\",\"detail\":\"%s\"},\"meta\":{\"instant\":\"%s\",\"context\":\"%s\",\"scope\":null,\"who\":null}}}";
    private static final String XML_TEMPLATE = "<?xml version=\"1.0\"?><log category=\"CLUSTER\"><content level=\"INFO\" message=\"%s\" detail=\"%s\"/><meta instant=\"%s\" context=\"%s\" scope=\"\" who=\"\"/></log>";
    private static final String YAML_TEMPLATE = "log: \n  category: \"CLUSTER\"\n  content: \n    level: \"INFO\"\n    message: \"%s\"\n    detail: \"%s\"\n  meta: \n    instant: \"%s\"\n    context: \"%s\"\n    scope: ~\n    who: ~\n";
    private final EventLogSerializer serializer = new EventLogSerializer();

    public void testJsonSerialization() {
        TestEventLog log = new TestEventLog();
        String expected = String.format(JSON_TEMPLATE, log.getMessage(), log.getDetail().get(), log.getWhen(), log.getContext().get());
        String actual = this.serialize(log, MediaType.APPLICATION_JSON);
        AssertJUnit.assertEquals((String)expected, (String)actual);
    }

    public void testXmlSerialization() {
        TestEventLog log = new TestEventLog();
        String expected = String.format(XML_TEMPLATE, log.getMessage(), log.getDetail().get(), log.getWhen(), log.getContext().get());
        String actual = this.serialize(log, MediaType.APPLICATION_XML);
        AssertJUnit.assertEquals((String)expected, (String)actual);
    }

    public void testYamlSerialization() {
        TestEventLog log = new TestEventLog();
        String expected = String.format(YAML_TEMPLATE, log.getMessage(), log.getDetail().get(), log.getWhen(), log.getContext().get());
        String actual = this.serialize(log, MediaType.APPLICATION_YAML);
        AssertJUnit.assertEquals((String)expected, (String)actual);
    }

    private String serialize(EventLog log, MediaType type) {
        StringWriter sw = new StringWriter();
        try (ConfigurationWriter cw = ConfigurationWriter.to((Writer)sw).withType(type).build();){
            cw.writeStartDocument();
            this.serializer.serialize(cw, log);
            cw.writeEndDocument();
        }
        return sw.toString();
    }

    private static class TestEventLog
    implements EventLog {
        private final Instant now = Instant.now();
        private final String message = UUID.randomUUID().toString();
        private final String detail = UUID.randomUUID().toString();
        private final String context = UUID.randomUUID().toString();

        private TestEventLog() {
        }

        public Instant getWhen() {
            return this.now;
        }

        public EventLogLevel getLevel() {
            return EventLogLevel.INFO;
        }

        public String getMessage() {
            return this.message;
        }

        public EventLogCategory getCategory() {
            return EventLogCategory.CLUSTER;
        }

        public Optional<String> getDetail() {
            return Optional.of(this.detail);
        }

        public Optional<String> getWho() {
            return Optional.empty();
        }

        public Optional<String> getContext() {
            return Optional.of(this.context);
        }

        public Optional<String> getScope() {
            return Optional.empty();
        }

        public int compareTo(EventLog eventLog) {
            return eventLog.getWhen().compareTo(this.getWhen());
        }
    }
}

