/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.concurrent.CompletionStage;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.CacheTopologyHandler;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.topology.LocalTopologyManagerImpl;
import org.infinispan.topology.ManagerStatusResponse;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.topology.RebalancingStatus;
import org.infinispan.util.logging.events.EventLogManager;

@Scope(value=Scopes.GLOBAL)
public abstract class AbstractControlledLocalTopologyManager
implements LocalTopologyManager {
    private final LocalTopologyManager delegate;

    @Inject
    void inject(BasicComponentRegistry bcr) {
        bcr.wireDependencies((Object)this.delegate, false);
        bcr.getComponent(EventLogManager.class).running();
    }

    @Start
    void start() {
        TestingUtil.startComponent(this.delegate);
    }

    @Stop
    void stop() {
        TestingUtil.stopComponent(this.delegate);
    }

    protected AbstractControlledLocalTopologyManager(LocalTopologyManager delegate) {
        this.delegate = delegate;
    }

    public final CompletionStage<CacheTopology> join(String cacheName, CacheJoinInfo joinInfo, CacheTopologyHandler stm, PartitionHandlingManager phm) throws Exception {
        return this.delegate.join(cacheName, joinInfo, stm, phm);
    }

    public final void leave(String cacheName, long timeout) {
        this.delegate.leave(cacheName, timeout);
    }

    public final void confirmRebalancePhase(String cacheName, int topologyId, int rebalanceId, Throwable throwable) {
        TestingUtil.sequence(this.beforeConfirmRebalancePhase(cacheName, topologyId, throwable), () -> {
            this.delegate.confirmRebalancePhase(cacheName, topologyId, rebalanceId, throwable);
            return CompletableFutures.completedNull();
        });
    }

    public final CompletionStage<ManagerStatusResponse> handleStatusRequest(int viewId) {
        return this.delegate.handleStatusRequest(viewId);
    }

    public final CompletionStage<Void> handleTopologyUpdate(String cacheName, CacheTopology cacheTopology, AvailabilityMode availabilityMode, int viewId, Address sender) {
        return TestingUtil.sequence(this.beforeHandleTopologyUpdate(cacheName, cacheTopology, viewId), () -> this.delegate.handleTopologyUpdate(cacheName, cacheTopology, availabilityMode, viewId, sender));
    }

    public final CompletionStage<Void> handleRebalance(String cacheName, CacheTopology cacheTopology, int viewId, Address sender) {
        return TestingUtil.sequence(this.beforeHandleRebalance(cacheName, cacheTopology, viewId), () -> this.delegate.handleRebalance(cacheName, cacheTopology, viewId, sender));
    }

    public final CacheTopology getCacheTopology(String cacheName) {
        return this.delegate.getCacheTopology(cacheName);
    }

    public CompletionStage<Void> handleStableTopologyUpdate(String cacheName, CacheTopology cacheTopology, Address sender, int viewId) {
        return this.delegate.handleStableTopologyUpdate(cacheName, cacheTopology, sender, viewId);
    }

    public CacheTopology getStableCacheTopology(String cacheName) {
        return this.delegate.getStableCacheTopology(cacheName);
    }

    public boolean isRebalancingEnabled() throws Exception {
        return this.delegate.isRebalancingEnabled();
    }

    public void setRebalancingEnabled(boolean enabled) throws Exception {
        this.delegate.setRebalancingEnabled(enabled);
    }

    public boolean isCacheRebalancingEnabled(String cacheName) throws Exception {
        return this.delegate.isCacheRebalancingEnabled(cacheName);
    }

    public void setCacheRebalancingEnabled(String cacheName, boolean enabled) throws Exception {
        this.delegate.setCacheRebalancingEnabled(cacheName, enabled);
    }

    public RebalancingStatus getRebalancingStatus(String cacheName) throws Exception {
        return this.delegate.getRebalancingStatus(cacheName);
    }

    public AvailabilityMode getCacheAvailability(String cacheName) {
        return this.delegate.getCacheAvailability(cacheName);
    }

    public void setCacheAvailability(String cacheName, AvailabilityMode availabilityMode) throws Exception {
        this.delegate.setCacheAvailability(cacheName, availabilityMode);
    }

    @Start
    public final void startDelegate() {
        if (this.delegate instanceof LocalTopologyManagerImpl) {
            ((LocalTopologyManagerImpl)this.delegate).start();
        }
    }

    @Stop
    public final void stopDelegate() {
        if (this.delegate instanceof LocalTopologyManagerImpl) {
            ((LocalTopologyManagerImpl)this.delegate).stop();
        }
    }

    protected CompletionStage<Void> beforeHandleTopologyUpdate(String cacheName, CacheTopology cacheTopology, int viewId) {
        return CompletableFutures.completedNull();
    }

    protected CompletionStage<Void> beforeHandleRebalance(String cacheName, CacheTopology cacheTopology, int viewId) {
        return CompletableFutures.completedNull();
    }

    protected CompletionStage<Void> beforeConfirmRebalancePhase(String cacheName, int topologyId, Throwable throwable) {
        return CompletableFutures.completedNull();
    }

    public PersistentUUID getPersistentUUID() {
        return this.delegate.getPersistentUUID();
    }

    public void cacheShutdown(String name) {
        this.delegate.cacheShutdown(name);
    }

    public CompletionStage<Void> handleCacheShutdown(String cacheName) {
        return this.delegate.handleCacheShutdown(cacheName);
    }

    public CompletionStage<Void> stableTopologyCompletion(String cacheName) {
        return CompletableFutures.completedNull();
    }
}

