/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery.admin;

import javax.transaction.xa.XAException;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.XaTransactionTable;
import org.infinispan.transaction.xa.recovery.RecoveryAwareTransactionTable;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.tx.recovery.PostCommitRecoveryStateTest;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.infinispan.tx.recovery.admin.AbstractRecoveryTest;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.admin.ForgetTest")
public class ForgetTest
extends AbstractRecoveryTest {
    private EmbeddedTransaction tx;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder configuration = this.defaultRecoveryConfig();
        this.createCluster(configuration, 2);
        this.waitForClusterToForm();
        RecoveryAwareTransactionTable txTable = this.tt(0);
        PostCommitRecoveryStateTest.RecoveryManagerDelegate recoveryManager = new PostCommitRecoveryStateTest.RecoveryManagerDelegate(TestingUtil.extractComponent(this.cache(0), RecoveryManager.class));
        TestingUtil.replaceField(recoveryManager, "recoveryManager", txTable, XaTransactionTable.class);
    }

    @BeforeMethod
    public void runTx() throws XAException {
        this.tx = RecoveryTestUtil.beginAndSuspendTx(this.cache(0));
        RecoveryTestUtil.prepareTransaction(this.tx);
        AssertJUnit.assertEquals((int)this.recoveryManager(0).getPreparedTransactionsFromCluster().all().length, (int)1);
        AssertJUnit.assertEquals((int)this.tt(0).getLocalPreparedXids().size(), (int)1);
        AssertJUnit.assertEquals((int)this.tt(1).getRemoteTxCount(), (int)1);
        RecoveryTestUtil.commitTransaction(this.tx);
        AssertJUnit.assertEquals((int)this.tt(1).getRemoteTxCount(), (int)1);
    }

    public void testInternalIdOnSameNode() {
        XidImpl xid = this.tx.getXid();
        this.recoveryOps(0).forget(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        AssertJUnit.assertEquals((int)this.tt(1).getRemoteTxCount(), (int)0);
    }

    public void testForgetXidOnSameNode() {
        this.forgetWithXid(0);
    }

    public void testForgetXidOnOtherNode() {
        this.forgetWithXid(1);
    }

    public void testForgetInternalIdOnSameNode() {
        this.forgetWithInternalId(0);
    }

    public void testForgetInternalIdOnOtherNode() {
        this.forgetWithInternalId(1);
    }

    protected void forgetWithInternalId(int cacheIndex) {
        long internalId = -1L;
        for (RemoteTransaction rt : this.tt(1).getRemoteTransactions()) {
            GlobalTransaction a = rt.getGlobalTransaction();
            if (!a.getXid().equals((Object)this.tx.getXid())) continue;
            internalId = a.getInternalId();
        }
        if (internalId == -1L) {
            throw new IllegalStateException();
        }
        log.tracef("About to forget... %s", internalId);
        this.recoveryOps(cacheIndex).forget(internalId);
        AssertJUnit.assertEquals((int)this.tt(0).getRemoteTxCount(), (int)0);
        AssertJUnit.assertEquals((int)this.tt(1).getRemoteTxCount(), (int)0);
    }

    private void forgetWithXid(int nodeIndex) {
        XidImpl xid = this.tx.getXid();
        this.recoveryOps(nodeIndex).forget(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        AssertJUnit.assertEquals((int)this.tt(1).getRemoteTxCount(), (int)0);
    }
}

