/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.locking;

import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.lookup.JBossStandaloneJTAManagerLookup;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.InvalidTransactionException;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.locking.RollbackDuringLockAcquisitionTest")
public class RollbackDuringLockAcquisitionTest
extends SingleCacheManagerTest {
    private static String concat(Object ... components) {
        return Arrays.stream(components).map(String::valueOf).map(String::toLowerCase).collect(Collectors.joining("-"));
    }

    @DataProvider(name="sync-tm")
    public Object[][] transactionManagerLookup() {
        return new Object[][]{{true, new EmbeddedTransactionManagerLookup()}, {true, new JBossStandaloneJTAManagerLookup()}, {false, new EmbeddedTransactionManagerLookup()}, {false, new JBossStandaloneJTAManagerLookup()}};
    }

    @Test(dataProvider="sync-tm")
    public void testRollbackWhileWaitingForLockDuringPut(boolean useSynchronization, TransactionManagerLookup lookup) throws Exception {
        String cacheName = RollbackDuringLockAcquisitionTest.concat("local-put", lookup.getClass().getSimpleName(), useSynchronization);
        String key = RollbackDuringLockAcquisitionTest.concat("reaper-put", lookup.getClass().getSimpleName(), useSynchronization);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().transactionManagerLookup(lookup).transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.PESSIMISTIC).useSynchronization(useSynchronization).recovery().disable();
        builder.locking().lockAcquisitionTimeout(TimeUnit.MINUTES.toMillis(1L));
        this.cacheManager.defineConfiguration(cacheName, builder.build());
        Cache cache = this.cacheManager.getCache(cacheName);
        LockManager lockManager = TestingUtil.extractLockManager(cache);
        TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
        lockManager.lock((Object)key, (Object)"_tx_", 1L, TimeUnit.SECONDS).lock();
        this.assertLocked(cache, key);
        tm.begin();
        CompletableFuture put = cache.putAsync((Object)key, (Object)"value1");
        GlobalTransaction gtx = TestingUtil.extractComponent(cache, TransactionTable.class).getGlobalTransaction(tm.getTransaction());
        RollbackDuringLockAcquisitionTest.eventually(() -> lockManager.getLock((Object)key).containsLockOwner((Object)gtx));
        tm.rollback();
        lockManager.unlock((Object)key, (Object)"_tx_");
        Exceptions.expectCompletionException(InvalidTransactionException.class, (CompletionStage)put);
        this.assertNotLocked(cache, key);
        this.assertNoTransactions(cache);
    }

    @Test(dataProvider="sync-tm")
    public void testRollbackWhileWaitingForLockDuringLock(boolean useSynchronization, TransactionManagerLookup lookup) throws Exception {
        String cacheName = RollbackDuringLockAcquisitionTest.concat("local-lock", lookup.getClass().getSimpleName(), useSynchronization);
        String key = RollbackDuringLockAcquisitionTest.concat("reaper-lock", lookup.getClass().getSimpleName(), useSynchronization);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().transactionManagerLookup(lookup).transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.PESSIMISTIC).useSynchronization(useSynchronization).recovery().disable();
        builder.locking().lockAcquisitionTimeout(TimeUnit.MINUTES.toMillis(1L));
        this.cacheManager.defineConfiguration(cacheName, builder.build());
        Cache cache = this.cacheManager.getCache(cacheName);
        LockManager lockManager = TestingUtil.extractLockManager(cache);
        TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
        lockManager.lock((Object)key, (Object)"_tx_", 1L, TimeUnit.SECONDS).lock();
        this.assertLocked(cache, key);
        AtomicReference tx = new AtomicReference();
        Future<Boolean> lock = this.fork(() -> {
            tm.begin();
            tx.set(tm.getTransaction());
            try {
                Boolean bl = cache.getAdvancedCache().lock((Object[])new String[]{key});
                return bl;
            }
            finally {
                this.safeRollback(tm);
            }
        });
        TransactionTable txTable = TestingUtil.extractComponent(cache, TransactionTable.class);
        RollbackDuringLockAcquisitionTest.eventually(() -> !txTable.getLocalGlobalTransaction().isEmpty());
        AssertJUnit.assertEquals((int)1, (int)txTable.getLocalGlobalTransaction().size());
        GlobalTransaction gtx = (GlobalTransaction)txTable.getLocalGlobalTransaction().iterator().next();
        RollbackDuringLockAcquisitionTest.eventually(() -> lockManager.getLock((Object)key).containsLockOwner((Object)gtx));
        ((Transaction)tx.get()).rollback();
        lockManager.unlock((Object)key, (Object)"_tx_");
        Exceptions.expectException(ExecutionException.class, InvalidTransactionException.class, lock::get);
        this.assertNotLocked(cache, key);
        this.assertNoTransactions(cache);
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager();
    }
}

