/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import java.util.concurrent.CountDownLatch;
import org.infinispan.Cache;
import org.infinispan.commons.tx.lookup.TransactionManagerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.lookup.EmbeddedTransactionManagerLookup;
import org.infinispan.transaction.tm.EmbeddedTransaction;
import org.infinispan.transaction.tm.EmbeddedTransactionManager;
import org.testng.annotations.Test;

@Test(testName="tx.StaleLockAfterTxAbortTest", groups={"unit"})
public class StaleLockAfterTxAbortTest
extends SingleCacheManagerTest {
    final String k = "key";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder c = this.getDefaultStandaloneCacheConfig(true);
        c.transaction().transactionManagerLookup((TransactionManagerLookup)new EmbeddedTransactionManagerLookup()).useSynchronization(false).recovery().disable();
        return TestCacheManagerFactory.createCacheManager(c);
    }

    public void doTest() throws Throwable {
        this.cache.put((Object)"key", (Object)"value");
        this.assertEventuallyNotLocked(this.cache, "key");
        EmbeddedTransactionManager dtm = (EmbeddedTransactionManager)this.tm();
        this.tm().begin();
        this.cache.put((Object)"key", (Object)"some");
        EmbeddedTransaction transaction = dtm.getTransaction();
        transaction.runPrepare();
        this.tm().suspend();
        this.assertLocked(this.cache, "key");
        CountDownLatch txStartedLatch = new CountDownLatch(1);
        TxThread transactionThread = new TxThread((Cache<Object, Object>)this.cache, txStartedLatch);
        transactionThread.start();
        txStartedLatch.countDown();
        Thread.sleep(500L);
        transactionThread.tm.resume(transactionThread.tx);
        transactionThread.tm.rollback();
        this.tm().resume((Transaction)transaction);
        transaction.runCommit(true);
        transactionThread.join();
        this.assertEventuallyNotLocked(this.cache, "key");
    }

    private class TxThread
    extends Thread {
        final Cache<Object, Object> cache;
        volatile Transaction tx;
        volatile Exception exception;
        final TransactionManager tm;
        final CountDownLatch txStartedLatch;

        private TxThread(Cache<Object, Object> cache, CountDownLatch txStartedLatch) {
            this.cache = cache;
            this.tx = null;
            this.tm = cache.getAdvancedCache().getTransactionManager();
            this.txStartedLatch = txStartedLatch;
        }

        @Override
        public void run() {
            try {
                this.tm.begin();
                this.tx = this.tm.getTransaction();
                log.trace((Object)("Started transaction " + String.valueOf(this.tx)));
                this.txStartedLatch.countDown();
                this.cache.put((Object)"key", (Object)"v2");
            }
            catch (Exception e) {
                this.exception = e;
            }
        }
    }
}

