/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import jakarta.transaction.RollbackException;
import jakarta.transaction.TransactionManager;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.remoting.inboundhandler.AbstractDelegatingHandler;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.impl.RemoteTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.ControlledConsistentHashFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.PessimisticDeadlockTest")
public class PessimisticDeadlockTest
extends MultipleCacheManagersTest {
    public void testDeadlock(Method method) throws Exception {
        AssertJUnit.assertEquals((int)4, (int)this.managers().length);
        String key = method.getName();
        this.assertOwnership(key);
        this.dropLockCommandInPrimary();
        Future<Boolean> tx1 = this.runTransaction(key, "tx1");
        Future<Boolean> tx2 = this.runTransaction(key, "tx2");
        this.awaitBackupLocks(key);
        this.killMember(1);
        AssertJUnit.assertEquals((int)3, (int)this.managers().length);
        this.assertOwnership(key);
        AssertJUnit.assertTrue((boolean)tx1.get(30L, TimeUnit.SECONDS));
        AssertJUnit.assertTrue((boolean)tx2.get(30L, TimeUnit.SECONDS));
        String result = (String)this.cache(0).get((Object)key);
        for (Cache cache : this.caches()) {
            AssertJUnit.assertEquals((String)result, (String)((String)cache.get((Object)key)));
        }
        this.assertNoTransactions();
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = PessimisticDeadlockTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        builder.clustering().hash().consistentHashFactory((ConsistentHashFactory)new ControlledConsistentHashFactory.Default(1, 2)).numSegments(1).numOwners(2);
        this.createClusteredCaches(4, builder);
    }

    private Future<Boolean> runTransaction(String key, String value) {
        return this.fork(() -> {
            AdvancedCache cache = this.cache(0).getAdvancedCache();
            TransactionManager tm = cache.getTransactionManager();
            tm.begin();
            cache.put((Object)key, (Object)value);
            try {
                tm.commit();
                return true;
            }
            catch (RollbackException e) {
                return false;
            }
        });
    }

    private void dropLockCommandInPrimary() {
        TestingUtil.wrapInboundInvocationHandler(this.cache(1), DropLockCommandHandler::new);
    }

    private void awaitBackupLocks(String key) {
        PessimisticDeadlockTest.eventually(() -> {
            TransactionTable table = TestingUtil.getTransactionTable(this.cache(2));
            Collection remoteTransactions = table.getRemoteTransactions();
            if (remoteTransactions.size() != 2) {
                return false;
            }
            for (RemoteTransaction rtx : remoteTransactions) {
                if (rtx.getBackupLockedKeys().contains(key)) continue;
                return false;
            }
            return true;
        });
    }

    private void assertOwnership(String key) {
        for (Cache cache : this.caches()) {
            List writeOwners = cache.getAdvancedCache().getDistributionManager().getCacheTopology().getDistribution((Object)key).writeOwners();
            AssertJUnit.assertEquals(Arrays.asList(this.address(1), this.address(2)), (Object)writeOwners);
        }
    }

    private static class DropLockCommandHandler
    extends AbstractDelegatingHandler {
        DropLockCommandHandler(PerCacheInboundInvocationHandler delegate) {
            super(delegate);
        }

        public void handle(CacheRpcCommand command, Reply reply, DeliverOrder order) {
            if (!(command instanceof LockControlCommand)) {
                this.delegate.handle(command, reply, order);
            }
        }
    }
}

