/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import javax.management.ObjectName;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="tx.NoRecoveryManagerByDefaultTest", groups={"functional"})
public class NoRecoveryManagerByDefaultTest
extends SingleCacheManagerTest {
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    public void testNoRecoveryManager() {
        AssertJUnit.assertTrue((boolean)this.cache.getCacheConfiguration().transaction().transactionMode().isTransactional());
        String jmxDomain = this.cacheManager.getCacheManagerConfiguration().jmx().domain();
        ObjectName recoveryManager = TestingUtil.getCacheObjectName(jmxDomain, this.cache.getName() + "(local)", "RecoveryManager");
        AssertJUnit.assertFalse((boolean)this.mBeanServerLookup.getMBeanServer().isRegistered(recoveryManager));
    }

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder().nonClusteredDefault();
        gcb.jmx().enabled(true).mBeanServerLookup(this.mBeanServerLookup);
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        return TestCacheManagerFactory.createCacheManager(gcb, cb);
    }
}

