/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.nio.file.Paths;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.Cache;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CheckPoint;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.topology.AbstractStatefulCluster;
import org.infinispan.topology.CacheJoinException;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.ClusterTopologyManager;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@CleanupAfterMethod
@Test(testName="topology.StatefulShutdownDuringJoinTest", groups={"functional"})
public class StatefulShutdownDuringJoinTest
extends AbstractStatefulCluster {
    private final int dataSize = 100;

    public StatefulShutdownDuringJoinTest() {
        this.clusterSize = 2;
        this.dataSize = 100;
    }

    @Override
    protected ConfigurationBuilder createCacheConfig(String id) {
        String stateDirectory = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), id});
        ConfigurationBuilder builder = StatefulShutdownDuringJoinTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
        builder.persistence().addSoftIndexFileStore().dataLocation(Paths.get(stateDirectory, "data").toString()).indexLocation(Paths.get(stateDirectory, "index").toString());
        return builder;
    }

    private void shutdownBeforeJoiningComplete() throws Exception {
        Cache c0 = this.manager(0).getCache(this.cacheName);
        Assertions.assertThat((boolean)this.manager(0).isCoordinator()).isTrue();
        this.fillData((Cache<Object, Object>)c0);
        CheckPoint checkPoint = new CheckPoint();
        ClusterTopologyManager originalCtm = TestingUtil.extractGlobalComponent((CacheContainer)this.manager(0), ClusterTopologyManager.class);
        ClusterTopologyManager spyCtm = (ClusterTopologyManager)Mockito.spy((Object)originalCtm);
        ((ClusterTopologyManager)Mockito.doAnswer(ivk -> {
            Object o = ivk.callRealMethod();
            checkPoint.trigger("after_invocation");
            checkPoint.awaitStrict("after_release", 5L, TimeUnit.SECONDS);
            return o;
        }).when((Object)spyCtm)).handleJoin((String)ArgumentMatchers.eq((Object)this.cacheName), (Address)ArgumentMatchers.any(), (CacheJoinInfo)ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        TestingUtil.replaceComponent((CacheContainer)this.manager(0), ClusterTopologyManager.class, spyCtm, true);
        Future<Void> create = this.fork(() -> this.waitForClusterToForm(this.cacheName));
        checkPoint.awaitStrict("after_invocation", 10L, TimeUnit.SECONDS);
        Assertions.assertThat((boolean)create.isDone()).isFalse();
        c0.shutdown();
        TestingUtil.killCacheManagers(this.managers());
        StatefulShutdownDuringJoinTest.eventually(create::isDone, 10L, TimeUnit.SECONDS);
    }

    public void testRestartStatelessCoordinator() throws Exception {
        this.shutdownBeforeJoiningComplete();
        this.assertClusterStateFiles();
        this.assertClusterStateFiles(this.manager(0), this.cacheName);
        this.cacheManagers.clear();
        this.createStatefulCacheManager(false, "B");
        Assertions.assertThat((boolean)this.manager(0).isCoordinator()).isTrue();
        Cache c1 = this.manager(0).getCache(this.cacheName);
        c1.put((Object)"k-0", (Object)"v1");
        this.createStatefulCacheManager(false, "A");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.waitForClusterToForm(this.cacheName)).rootCause().isInstanceOf(CacheJoinException.class)).hasMessageStartingWith("ISPN000408:");
        Assertions.assertThat((Object)c1.get((Object)"k-0")).isEqualTo((Object)"v1");
        Assertions.assertThat((int)c1.size()).isOne();
    }

    public void testRestartStatefulCoordinatorAndStatelessBackup() throws Exception {
        this.shutdownBeforeJoiningComplete();
        this.assertClusterStateFiles();
        this.assertClusterStateFiles(this.manager(0), this.cacheName);
        this.cacheManagers.clear();
        this.createStatefulCacheManager(false, "A");
        Assertions.assertThat((boolean)this.manager(0).isCoordinator()).isTrue();
        this.createStatefulCacheManager(false, "B");
        this.waitForClusterToForm(this.cacheName);
        this.assertData((Cache<Object, Object>)this.manager(1).getCache(this.cacheName));
    }

    private void fillData(Cache<Object, Object> cache) {
        for (int i = 0; i < 100; ++i) {
            cache.put((Object)("k-" + i), (Object)("v-" + i));
        }
    }

    private void assertData(Cache<Object, Object> cache) {
        Assertions.assertThat((int)cache.size()).isEqualTo(100);
        for (int i = 0; i < 100; ++i) {
            Assertions.assertThat((Object)cache.get((Object)("k-" + i))).isEqualTo((Object)("v-" + i));
        }
    }
}

