/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.CacheTopologyHandler;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.topology.ManagerStatusResponse;
import org.infinispan.topology.PersistentUUID;
import org.infinispan.topology.RebalancingStatus;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;

class MockLocalTopologyManager
implements LocalTopologyManager {
    private static final Log log = LogFactory.getLog(MockLocalTopologyManager.class);
    private final String cacheName;
    private final BlockingQueue<CacheTopology> topologies = new LinkedBlockingDeque<CacheTopology>();
    private CacheStatusResponse status;

    MockLocalTopologyManager(String cacheName) {
        this.cacheName = cacheName;
    }

    public void init(CacheJoinInfo joinInfo, CacheTopology topology, CacheTopology stableTopology, AvailabilityMode availabilityMode) {
        this.status = new CacheStatusResponse(joinInfo, topology, stableTopology, availabilityMode, Collections.emptyList());
    }

    public void verifyTopology(CacheTopology topology, int topologyId, List<Address> currentMembers, List<Address> pendingMembers, CacheTopology.Phase phase) {
        log.debugf("Verifying topology %s", (Object)topology);
        AssertJUnit.assertEquals((int)topologyId, (int)topology.getTopologyId());
        AssertJUnit.assertEquals((Object)phase, (Object)topology.getPhase());
        AssertJUnit.assertEquals(currentMembers, (Object)topology.getCurrentCH().getMembers());
        if (pendingMembers != null) {
            AssertJUnit.assertEquals(pendingMembers, (Object)topology.getPendingCH().getMembers());
        } else {
            AssertJUnit.assertNull((Object)topology.getPendingCH());
        }
    }

    public void expectTopology(int topologyId, List<Address> currentMembers, List<Address> pendingMembers, CacheTopology.Phase phase) throws Exception {
        CacheTopology topology = this.topologies.poll(10L, TimeUnit.SECONDS);
        AssertJUnit.assertNotNull((String)("Timed out waiting for topology " + topologyId), (Object)topology);
        this.verifyTopology(topology, topologyId, currentMembers, pendingMembers, phase);
    }

    public CompletionStage<CacheTopology> join(String cacheName, CacheJoinInfo joinInfo, CacheTopologyHandler stm, PartitionHandlingManager phm) {
        throw new UnsupportedOperationException();
    }

    public void leave(String cacheName, long timeout) {
        throw new UnsupportedOperationException();
    }

    public void confirmRebalancePhase(String cacheName, int topologyId, int rebalanceId, Throwable throwable) {
        throw new UnsupportedOperationException();
    }

    public CompletionStage<ManagerStatusResponse> handleStatusRequest(int viewId) {
        Map caches = this.status.getCacheJoinInfo() != null ? Collections.singletonMap(this.cacheName, this.status) : Collections.emptyMap();
        return CompletableFuture.completedFuture(new ManagerStatusResponse(caches, true));
    }

    public CompletionStage<Void> handleTopologyUpdate(String cacheName, CacheTopology cacheTopology, AvailabilityMode availabilityMode, int viewId, Address sender) {
        this.status = new CacheStatusResponse(this.status.getCacheJoinInfo(), cacheTopology, this.status.getStableTopology(), availabilityMode, this.status.joinedMembers());
        this.topologies.add(cacheTopology);
        return CompletableFutures.completedNull();
    }

    public CompletionStage<Void> handleStableTopologyUpdate(String cacheName, CacheTopology cacheTopology, Address sender, int viewId) {
        this.status = new CacheStatusResponse(this.status.getCacheJoinInfo(), this.status.getCacheTopology(), cacheTopology, this.status.getAvailabilityMode(), this.status.joinedMembers());
        return CompletableFutures.completedNull();
    }

    public CompletionStage<Void> handleRebalance(String cacheName, CacheTopology cacheTopology, int viewId, Address sender) {
        this.status = new CacheStatusResponse(this.status.getCacheJoinInfo(), cacheTopology, this.status.getStableTopology(), this.status.getAvailabilityMode(), this.status.joinedMembers());
        this.topologies.add(cacheTopology);
        return CompletableFutures.completedNull();
    }

    public CacheTopology getCacheTopology(String cacheName) {
        return this.status.getCacheTopology();
    }

    public CacheTopology getStableCacheTopology(String cacheName) {
        return this.status.getStableTopology();
    }

    public boolean isRebalancingEnabled() {
        return true;
    }

    public boolean isCacheRebalancingEnabled(String cacheName) {
        return true;
    }

    public void setRebalancingEnabled(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    public void setCacheRebalancingEnabled(String cacheName, boolean enabled) {
        throw new UnsupportedOperationException();
    }

    public RebalancingStatus getRebalancingStatus(String cacheName) {
        throw new UnsupportedOperationException();
    }

    public AvailabilityMode getCacheAvailability(String cacheName) {
        return this.status.getAvailabilityMode();
    }

    public void setCacheAvailability(String cacheName, AvailabilityMode availabilityMode) {
        throw new UnsupportedOperationException();
    }

    public PersistentUUID getPersistentUUID() {
        return null;
    }

    public void cacheShutdown(String name) {
        throw new UnsupportedOperationException();
    }

    public CompletionStage<Void> handleCacheShutdown(String cacheName) {
        throw new UnsupportedOperationException();
    }

    public CompletionStage<Void> stableTopologyCompletion(String cacheName) {
        return CompletableFutures.completedNull();
    }
}

