/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.infinispan.commons.test.CommonsTestingUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;

public abstract class AbstractStatefulCluster
extends MultipleCacheManagersTest {
    protected int clusterSize = 3;
    protected String cacheName = "clusterTestCache";

    @Override
    protected void createCacheManagers() throws Throwable {
        Util.recursiveFileRemove((String)CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName()}));
        this.createStatefulCacheManager(true);
    }

    protected void createStatefulCacheManager(boolean clear) {
        for (int i = 0; i < this.clusterSize; ++i) {
            this.createStatefulCacheManager(clear, Character.toString(65 + i));
        }
    }

    protected void createStatefulCacheManager(boolean clear, String id) {
        String stateDirectory = CommonsTestingUtil.tmpDirectory((String[])new String[]{this.getClass().getSimpleName(), id});
        if (clear) {
            Util.recursiveFileRemove((String)stateDirectory);
        }
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        global.globalState().enable().persistentLocation(stateDirectory);
        EmbeddedCacheManager ecm = this.addClusterEnabledCacheManager(global, null);
        ConfigurationBuilder builder = this.createCacheConfig(id);
        if (builder != null) {
            ecm.defineConfiguration(this.cacheName, builder.build());
        }
    }

    protected ConfigurationBuilder createCacheConfig(String id) {
        return null;
    }

    protected final void assertClusterStateFiles() throws IOException {
        this.assertClusterStateFiles(null);
    }

    protected final void assertClusterStateFiles(String cacheName) throws IOException {
        for (int i = 0; i < this.clusterSize; ++i) {
            this.assertClusterStateFiles(this.manager(i), cacheName);
        }
    }

    protected final void assertClusterStateFiles(EmbeddedCacheManager ecm, String cacheName) throws IOException {
        String persistentLocation = ecm.getCacheManagerConfiguration().globalState().persistentLocation();
        boolean globalState = false;
        boolean cacheState = cacheName == null;
        try (Stream<Path> s = Files.list(Path.of(persistentLocation, new String[0]));){
            Path[] paths;
            for (Path p : paths = (Path[])s.toArray(Path[]::new)) {
                globalState |= p.endsWith("___global.state");
                cacheState |= p.endsWith(cacheName + ".state");
            }
        }
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)globalState).as("Global state present for " + String.valueOf(ecm.getAddress()), new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)cacheState).as(cacheName + " state present for " + String.valueOf(ecm.getAddress()), new Object[0])).isTrue();
    }
}

