/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.concurrent;

import org.infinispan.test.concurrent.InvocationMatcher;
import org.infinispan.test.concurrent.StateSequencer;

public class StateInvocationMatcher
implements InvocationMatcher {
    private final InvocationMatcher matcher;
    private final StateSequencer stateSequencer;
    private final String stateName;
    private final Relation relation;

    public StateInvocationMatcher(InvocationMatcher matcher, StateSequencer stateSequencer, Relation relation, String stateName) {
        this.matcher = matcher;
        this.stateSequencer = stateSequencer;
        this.relation = relation;
        this.stateName = stateName;
    }

    @Override
    public boolean accept(Object instance, String methodName, Object[] arguments) {
        boolean accept = false;
        switch (this.relation.ordinal()) {
            case 0: {
                accept = this.stateSequencer.isInState(this.stateName);
                break;
            }
            case 1: {
                accept = this.stateSequencer.isInOrAfterState(this.stateName);
                break;
            }
            case 2: {
                accept = this.stateSequencer.isAfterState(this.stateName);
                break;
            }
            default: {
                throw new IllegalStateException(String.valueOf((Object)this.relation));
            }
        }
        if (accept) {
            return this.matcher.accept(instance, methodName, arguments);
        }
        return false;
    }

    public static enum Relation {
        IN,
        IN_OR_AFTER,
        AFTER;

    }
}

