/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.test.concurrent.CommandMatcher;

public class MatchCountMatcher
implements CommandMatcher {
    private final CommandMatcher matcher;
    private final int matchCount;
    private final AtomicInteger parentMatchCount = new AtomicInteger(0);

    MatchCountMatcher(CommandMatcher matcher, int matchCount) {
        if (matchCount < 0) {
            throw new IllegalArgumentException("matchCount must be positive");
        }
        this.matcher = matcher;
        this.matchCount = matchCount;
    }

    @Override
    public boolean accept(ReplicableCommand command) {
        if (!this.matcher.accept(command)) {
            return false;
        }
        return this.parentMatchCount.getAndIncrement() == this.matchCount;
    }
}

