/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.concurrent.CommandMatcher;

public class DefaultCommandMatcher
implements CommandMatcher {
    public static final Address LOCAL_ORIGIN_PLACEHOLDER = new AddressPlaceholder();
    public static final Address ANY_REMOTE_PLACEHOLDER = new AddressPlaceholder();
    private final Class<? extends ReplicableCommand> commandClass;
    private final String cacheName;
    private final Address origin;
    private final Object key;
    private final AtomicInteger actualMatchCount = new AtomicInteger(0);

    public DefaultCommandMatcher(Class<? extends ReplicableCommand> commandClass) {
        this(commandClass, null, null, null);
    }

    public DefaultCommandMatcher(Class<? extends CacheRpcCommand> commandClass, String cacheName, Address origin) {
        this(commandClass, cacheName, origin, null);
    }

    public DefaultCommandMatcher(Class<? extends DataCommand> commandClass, Object key) {
        this(commandClass, null, null, key);
    }

    DefaultCommandMatcher(Class<? extends ReplicableCommand> commandClass, String cacheName, Address origin, Object key) {
        this.commandClass = commandClass;
        this.cacheName = cacheName;
        this.origin = origin;
        this.key = key;
    }

    @Override
    public boolean accept(ReplicableCommand command) {
        if (this.commandClass != null && this.commandClass != command.getClass()) {
            return false;
        }
        if (this.cacheName != null && !this.cacheName.equals(((CacheRpcCommand)command).getCacheName().toString())) {
            return false;
        }
        if (this.origin != null && !this.addressMatches((CacheRpcCommand)command)) {
            return false;
        }
        return this.key == null || this.key.equals(((DataCommand)command).getKey());
    }

    private boolean addressMatches(CacheRpcCommand command) {
        Address commandOrigin = command.getOrigin();
        if (this.origin == LOCAL_ORIGIN_PLACEHOLDER) {
            return commandOrigin == null;
        }
        if (this.origin == ANY_REMOTE_PLACEHOLDER) {
            return commandOrigin != null;
        }
        return !this.origin.equals((Object)commandOrigin);
    }

    private static class AddressPlaceholder
    implements Address {
        private AddressPlaceholder() {
        }

        public int compareTo(Address o) {
            throw new UnsupportedOperationException("This address should never be part of a view");
        }
    }
}

