/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stress;

import jakarta.transaction.TransactionManager;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="stress.AbstractWriteSkewStressTest", groups={"stress"})
public abstract class AbstractWriteSkewStressTest
extends MultipleCacheManagersTest {
    private static final String SHARED_COUNTER_TEST_KEY = "counter";
    private static final int SHARED_COUNTER_TEST_MAX_COUNTER_VALUE = 1000;

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = TestCacheManagerFactory.getDefaultCacheConfiguration(true);
        builder.clustering().cacheMode(this.getCacheMode()).locking().isolationLevel(IsolationLevel.REPEATABLE_READ).lockAcquisitionTimeout(TestingUtil.shortTimeoutMillis()).transaction().lockingMode(LockingMode.OPTIMISTIC);
        this.decorate(builder);
        this.createCluster(builder, 2);
        this.waitForClusterToForm();
    }

    protected void decorate(ConfigurationBuilder builder) {
    }

    protected abstract CacheMode getCacheMode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedCounter() {
        Cache c1 = this.cache(0);
        Cache c2 = this.cache(1);
        c1.put((Object)SHARED_COUNTER_TEST_KEY, (Object)0);
        AssertJUnit.assertEquals((String)"Initial value is different from zero in cache 1", (int)0, (int)((Integer)c1.get((Object)SHARED_COUNTER_TEST_KEY)));
        AssertJUnit.assertEquals((String)"Initial value is different from zero in cache 2", (int)0, (int)((Integer)c2.get((Object)SHARED_COUNTER_TEST_KEY)));
        ConcurrentSkipListSet<Integer> uniqueValuesIncremented = new ConcurrentSkipListSet<Integer>();
        Future<Boolean> f1 = this.fork(new IncrementCounterTask(c1, uniqueValuesIncremented));
        Future<Boolean> f2 = this.fork(new IncrementCounterTask(c2, uniqueValuesIncremented));
        try {
            AssertJUnit.assertTrue((String)("Cache 1 [" + String.valueOf(this.address(c1)) + "] has put a duplicate value"), (boolean)f1.get(5L, TimeUnit.MINUTES));
            AssertJUnit.assertTrue((String)("Cache 2 [" + String.valueOf(this.address(c2)) + "] has put a duplicate value"), (boolean)f2.get(5L, TimeUnit.MINUTES));
        }
        catch (InterruptedException e) {
            AssertJUnit.fail((String)"Interrupted exception while running the test");
        }
        catch (ExecutionException e) {
            log.error((Object)"Exception in running updater threads", (Throwable)e);
            AssertJUnit.fail((String)"Exception running updater threads");
        }
        catch (TimeoutException e) {
            AssertJUnit.fail((String)"Timed out waiting for updater threads");
        }
        finally {
            f1.cancel(true);
            f2.cancel(true);
        }
        AssertJUnit.assertTrue((String)("Cache 1 [" + String.valueOf(this.address(c1)) + "] fina value is less than 1000"), ((Integer)c1.get((Object)SHARED_COUNTER_TEST_KEY) >= 1000 ? 1 : 0) != 0);
        AssertJUnit.assertTrue((String)("Cache 2 [" + String.valueOf(this.address(c2)) + "] fina value is less than 1000"), ((Integer)c2.get((Object)SHARED_COUNTER_TEST_KEY) >= 1000 ? 1 : 0) != 0);
    }

    private class IncrementCounterTask
    implements Callable<Boolean> {
        private final Cache<String, Integer> cache;
        private final Set<Integer> uniqueValuesSet;
        private final TransactionManager transactionManager;
        private int lastValue;

        public IncrementCounterTask(Cache<String, Integer> cache, Set<Integer> uniqueValuesSet) {
            this.cache = cache;
            this.transactionManager = cache.getAdvancedCache().getTransactionManager();
            this.uniqueValuesSet = uniqueValuesSet;
            this.lastValue = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws InterruptedException {
            boolean unique = true;
            while (this.lastValue < 1000 && !Thread.interrupted()) {
                boolean success = false;
                try {
                    this.transactionManager.begin();
                    Integer value = (Integer)this.cache.get((Object)AbstractWriteSkewStressTest.SHARED_COUNTER_TEST_KEY);
                    value = value + 1;
                    this.lastValue = value;
                    this.cache.put((Object)AbstractWriteSkewStressTest.SHARED_COUNTER_TEST_KEY, (Object)value);
                    this.transactionManager.commit();
                    unique = this.uniqueValuesSet.add(value);
                    success = true;
                }
                catch (Exception t) {}
                continue;
                finally {
                    if (!success) {
                        try {
                            if (this.transactionManager.getStatus() != 6) {
                                this.transactionManager.rollback();
                            }
                        }
                        catch (Throwable t) {
                            log.trace((Object)"Exception during rollback", t);
                        }
                    }
                    AssertJUnit.assertTrue((String)("Duplicate value found in " + String.valueOf(AbstractWriteSkewStressTest.this.address(this.cache)) + " (value=" + this.lastValue + ")"), (boolean)unique);
                }
            }
            return unique;
        }
    }
}

