/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.context.Flag;
import org.infinispan.distribution.MagicKey;
import org.infinispan.marshall.TestObjectStreamMarshaller;
import org.infinispan.marshall.persistence.impl.MarshalledEntryUtil;
import org.infinispan.persistence.dummy.DummyInMemoryStore;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.TransactionMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="stream.BaseStreamIteratorWithLoaderTest")
public abstract class BaseStreamIteratorWithLoaderTest
extends MultipleCacheManagersTest {
    protected ConfigurationBuilder builderUsed;
    protected SerializationContextInitializer sci;
    protected final boolean tx;
    protected final CacheMode cacheMode;

    public BaseStreamIteratorWithLoaderTest(boolean tx, CacheMode cacheMode) {
        this.tx = tx;
        this.cacheMode = cacheMode;
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.sci = TestDataSCI.INSTANCE;
        this.builderUsed = new ConfigurationBuilder();
        this.builderUsed.clustering().cacheMode(this.cacheMode);
        this.builderUsed.clustering().hash().numOwners(1);
        ((DummyInMemoryStoreConfigurationBuilder)this.builderUsed.persistence().passivation(false).addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(this.getClass().getSimpleName());
        if (this.tx) {
            this.builderUsed.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        }
        this.createClusteredCaches(this.cacheMode.isClustered() ? 3 : 1, this.sci, this.builderUsed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Object, String> insertDefaultValues(boolean includeLoaderEntry) {
        Serializable loaderKey;
        Cache cache0 = this.cache(0);
        HashMap<Object, String> originalValues = new HashMap<Object, String>();
        if (this.cacheMode.needsStateTransfer()) {
            Cache cache1 = this.cache(1);
            Cache cache2 = this.cache(2);
            originalValues.put(new MagicKey(cache0), "cache0");
            originalValues.put(new MagicKey(cache1), "cache1");
            originalValues.put(new MagicKey(cache2), "cache2");
            loaderKey = new MagicKey(cache2);
        } else {
            originalValues.put(1, "value0");
            originalValues.put(2, "value1");
            originalValues.put(3, "value2");
            loaderKey = 4;
        }
        cache0.putAll(originalValues);
        DummyInMemoryStore store = (DummyInMemoryStore)TestingUtil.getFirstStore(cache0);
        TestObjectStreamMarshaller sm = new TestObjectStreamMarshaller(this.sci);
        try {
            String loaderValue = "loader-value";
            store.write(MarshalledEntryUtil.create(loaderKey, loaderValue, (Marshaller)sm));
            if (includeLoaderEntry) {
                originalValues.put(loaderKey, loaderValue);
            }
        }
        finally {
            sm.stop();
        }
        return originalValues;
    }

    @Test
    public void testCacheLoader() {
        Map<Object, String> originalValues = this.insertDefaultValues(true);
        Cache cache = this.cache(0);
        Iterator iterator = cache.entrySet().stream().iterator();
        int count = 0;
        HashMap results = new HashMap();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            results.put(entry.getKey(), (String)entry.getValue());
            ++count;
        }
        Assert.assertEquals((int)count, (int)4);
        Assert.assertEquals(originalValues, results);
    }

    @Test
    public void testCacheLoaderIgnored() {
        Map<Object, String> originalValues = this.insertDefaultValues(false);
        Cache cache = this.cache(0);
        Iterator iterator = cache.getAdvancedCache().withFlags(Flag.SKIP_CACHE_LOAD).entrySet().stream().iterator();
        int count = 0;
        HashMap results = new HashMap();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            results.put(entry.getKey(), (String)entry.getValue());
            ++count;
        }
        Assert.assertEquals((int)count, (int)3);
        Assert.assertEquals(originalValues, results);
    }
}

