/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestDataSCI;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(testName="statetransfer.StateTransferExpiredStoreTest", groups={"functional"})
public class StateTransferExpiredStoreTest
extends MultipleCacheManagersTest {
    private ControlledTimeService timeService;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.timeService = new ControlledTimeService();
        this.createCluster(TestDataSCI.INSTANCE, null, 2);
        TestingUtil.replaceComponent((CacheContainer)this.manager(0), TimeService.class, this.timeService, true);
        TestingUtil.replaceComponent((CacheContainer)this.manager(1), TimeService.class, this.timeService, true);
    }

    private ConfigurationBuilder getConfigurationBuilder(CacheMode cacheMode) {
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        ((DummyInMemoryStoreConfigurationBuilder)cfg.persistence().addStore(DummyInMemoryStoreConfigurationBuilder.class)).fetchPersistentState(true);
        cfg.clustering().cacheMode(cacheMode);
        cfg.clustering().stateTransfer().timeout(30000L);
        return cfg;
    }

    @DataProvider
    Object[][] cacheModes() {
        return new Object[][]{{CacheMode.DIST_SYNC}, {CacheMode.REPL_SYNC}};
    }

    @Test(dataProvider="cacheModes")
    public void testStateTransfer(CacheMode cacheMode) {
        String cacheName = "cache_" + String.valueOf(cacheMode);
        Configuration configuration = this.getConfigurationBuilder(cacheMode).build();
        this.manager(0).defineConfiguration(cacheName, configuration);
        this.manager(1).defineConfiguration(cacheName, configuration);
        AdvancedCache cache0 = this.advancedCache(0, cacheName);
        String value = "value";
        cache0.put((Object)"immortal", (Object)value);
        for (int i = 1; i <= 3; ++i) {
            cache0.put((Object)("lifespan+maxidle" + i), (Object)value, (long)i, TimeUnit.SECONDS, (long)i, TimeUnit.SECONDS);
            cache0.put((Object)("lifespan" + i), (Object)value, (long)i, TimeUnit.SECONDS);
            cache0.put((Object)("maxidle" + i), (Object)value, -1L, TimeUnit.SECONDS, (long)i, TimeUnit.SECONDS);
            cache0.put((Object)("lifespan+maxidle" + i), (Object)value, (long)i, TimeUnit.SECONDS, (long)i, TimeUnit.SECONDS);
        }
        log.info((Object)"timeService.advance");
        this.timeService.advance(TimeUnit.SECONDS.toMillis(2L));
        AdvancedCache cache1 = this.advancedCache(1, cacheName);
        AssertJUnit.assertEquals((Object)value, (Object)cache1.get((Object)"immortal"));
        for (int i = 2; i <= 3; ++i) {
            AssertJUnit.assertEquals((Object)value, (Object)cache0.get((Object)("lifespan+maxidle" + i)));
            AssertJUnit.assertEquals((Object)value, (Object)cache0.get((Object)("lifespan" + i)));
            AssertJUnit.assertEquals((Object)value, (Object)cache0.get((Object)("maxidle" + i)));
            AssertJUnit.assertEquals((Object)value, (Object)cache0.get((Object)("lifespan+maxidle" + i)));
        }
    }
}

